/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelController;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModelController
implements ModelController {
    private static final Logger logger = Logger.getLogger(ServerModelController.class.getName());
    private final FreeColServer freeColServer;
    private final HashMap<String, TaskEntry> taskRegister = new HashMap();

    public ServerModelController(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    @Override
    public synchronized int getRandom(String taskID, int n) {
        int turnNumber = this.freeColServer.getGame().getTurn().getNumber();
        String extendedTaskID = taskID + Integer.toString(turnNumber);
        if (this.taskRegister.containsKey(extendedTaskID)) {
            return (Integer)this.taskRegister.get((Object)extendedTaskID).entry;
        }
        int value = this.getPseudoRandom().nextInt(n);
        this.taskRegister.put(extendedTaskID, new TaskEntry(extendedTaskID, turnNumber, true, new Integer(value)));
        return value;
    }

    @Override
    public PseudoRandom getPseudoRandom() {
        return this.freeColServer.getPseudoRandom();
    }

    public synchronized void clearTaskRegister() {
        int currentTurn = this.freeColServer.getGame().getTurn().getNumber();
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (TaskEntry te : this.taskRegister.values()) {
            if (!te.hasExpired(currentTurn)) continue;
            if (!te.isSecure()) {
                logger.warning("Possibly a cheating attempt.");
            }
            idsToRemove.add(te.taskID);
        }
        if (!idsToRemove.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Clearing the task register. Removing the following items:");
            for (String id : idsToRemove) {
                this.taskRegister.remove(id);
                sb.append(" ");
                sb.append(id);
            }
            logger.info(sb.toString());
        }
    }

    @Override
    public synchronized Unit createUnit(String taskID, Location location, Player owner, UnitType type) {
        return this.createUnit(taskID, location, owner, type, true, null);
    }

    public synchronized Unit createUnit(String taskID, Location location, Player owner, UnitType type, boolean secure, Connection connection) {
        Unit unit;
        String extendedTaskID = taskID + owner.getId() + Integer.toString(this.freeColServer.getGame().getTurn().getNumber());
        logger.info("Entering createUnit.");
        if (this.taskRegister.containsKey(extendedTaskID)) {
            TaskEntry taskEntry = this.taskRegister.get(extendedTaskID);
            unit = (Unit)taskEntry.entry;
            if (unit.getLocation().getTile() != location.getTile() || unit.getOwner() != owner || unit.getType() != type) {
                logger.warning("Unsynchronization between the client and the server. Maybe a cheating attempt! Differences: " + (unit.getLocation().getTile() != location.getTile() ? "location: " + unit.getLocation().getTile() + "!=" + location.getTile() : "") + (unit.getOwner() != owner ? "owner: " + unit.getOwner() + "!=" + owner : "") + (unit.getType() != type ? "type: " + unit.getType() + "!=" + type : ""));
                this.taskRegister.remove(extendedTaskID);
                unit.dispose();
                return null;
            }
            if (secure) {
                taskEntry.secure = true;
            }
        } else {
            unit = new Unit(this.freeColServer.getGame(), location, owner, type, Unit.UnitState.ACTIVE);
            TaskEntry taskEntry = new TaskEntry(extendedTaskID, this.freeColServer.getGame().getTurn().getNumber(), secure, unit);
            this.taskRegister.put(extendedTaskID, taskEntry);
        }
        return unit;
    }

    @Override
    public synchronized Building createBuilding(String taskID, Colony colony, BuildingType type) {
        return this.createBuilding(taskID, colony, type, true, null);
    }

    public synchronized Building createBuilding(String taskID, Colony colony, BuildingType type, boolean secure, Connection connection) {
        Building building;
        String extendedTaskID = taskID + colony.getOwner().getId() + Integer.toString(this.freeColServer.getGame().getTurn().getNumber());
        Player owner = colony.getOwner();
        logger.info("Entering createBuilding.");
        if (this.taskRegister.containsKey(extendedTaskID)) {
            TaskEntry taskEntry = this.taskRegister.get(extendedTaskID);
            building = (Building)taskEntry.entry;
            if (building.getColony().getTile() != colony.getTile() || building.getOwner() != colony.getOwner() || building.getType() != type) {
                logger.warning("Unsynchronization between the client and the server. Maybe a cheating attempt! Differences: " + (building.getColony().getTile() != colony.getTile() ? "colony: " + building.getColony().getTile() + "!=" + colony.getTile() : "") + (building.getOwner() != owner ? "owner: " + building.getOwner() + "!=" + owner : "") + (building.getType() != type ? "type: " + building.getType() + "!=" + type : ""));
                this.taskRegister.remove(extendedTaskID);
                building.dispose();
                return null;
            }
            if (secure) {
                taskEntry.secure = true;
            }
        } else {
            building = new Building(this.freeColServer.getGame(), colony, type);
            TaskEntry taskEntry = new TaskEntry(extendedTaskID, this.freeColServer.getGame().getTurn().getNumber(), secure, building);
            this.taskRegister.put(extendedTaskID, taskEntry);
        }
        return building;
    }

    @Override
    public synchronized Location setToVacantEntryLocation(Unit unit) {
        Location entryLocation;
        Game game = this.freeColServer.getGame();
        ServerPlayer player = (ServerPlayer)unit.getOwner();
        String taskID = unit.getId() + Integer.toString(this.freeColServer.getGame().getTurn().getNumber());
        if (this.taskRegister.containsKey(taskID)) {
            entryLocation = (Location)this.taskRegister.get((Object)taskID).entry;
        } else {
            entryLocation = unit.getVacantEntryLocation();
            this.taskRegister.put(taskID, new TaskEntry(taskID, this.freeColServer.getGame().getTurn().getNumber(), true, entryLocation));
        }
        unit.setLocation(entryLocation);
        unit.setState(Unit.UnitState.ACTIVE);
        Element updateElement = Message.createNewRootElement("update");
        List<Tile> surroundingTiles = game.getMap().getSurroundingTiles(unit.getTile(), unit.getLineOfSight());
        for (int i = 0; i < surroundingTiles.size(); ++i) {
            Tile t = surroundingTiles.get(i);
            updateElement.appendChild(t.toXMLElement(player, updateElement.getOwnerDocument()));
        }
        try {
            player.getConnection().send(updateElement);
        }
        catch (IOException e) {
            logger.warning("Could not send message to: " + player.getName() + " with connection " + player.getConnection());
        }
        this.update(unit.getTile(), (Player)player);
        return entryLocation;
    }

    public void update(Tile tile) {
        this.update(tile, null);
    }

    @Override
    public void exploreTiles(Player player, ArrayList<Tile> tiles) {
        Element updateElement = Message.createNewRootElement("update");
        for (int i = 0; i < tiles.size(); ++i) {
            Tile t = tiles.get(i);
            t.setExploredBy(player, true);
            updateElement.appendChild(t.toXMLElement(player, updateElement.getOwnerDocument()));
        }
        try {
            ((ServerPlayer)player).getConnection().send(updateElement);
        }
        catch (IOException e) {
            logger.warning("Could not send message to: " + ((ServerPlayer)player).getName() + " with connection " + ((ServerPlayer)player).getConnection());
        }
    }

    @Override
    public void setStance(Player first, Player second, Player.Stance stance) {
        Element element = Message.createNewRootElement("setStance");
        element.setAttribute("stance", stance.toString());
        element.setAttribute("first", first.getId());
        element.setAttribute("second", second.getId());
        Iterator<Player> enemyPlayerIterator = first.getGame().getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (enemyPlayer.equals(first)) continue;
            try {
                enemyPlayer.getConnection().send(element);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    public void update(Tile newTile, Player p) {
        ServerPlayer player = (ServerPlayer)p;
        Game game = this.freeColServer.getGame();
        Iterator<Player> enemyPlayerIterator = game.getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (player != null && player.equals(enemyPlayer)) continue;
            try {
                if (!enemyPlayer.canSee(newTile)) continue;
                Element updateElement = Message.createNewRootElement("update");
                updateElement.appendChild(newTile.toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                enemyPlayer.getConnection().send(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    public void update(Unit unit, Player p) {
        ServerPlayer player = (ServerPlayer)p;
        Game game = this.freeColServer.getGame();
        Iterator<Player> enemyPlayerIterator = game.getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (player != null && player.equals(enemyPlayer)) continue;
            try {
                if (!unit.isVisibleTo(enemyPlayer)) continue;
                Element updateElement = Message.createNewRootElement("update");
                updateElement.appendChild(unit.getTile().toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                enemyPlayer.getConnection().send(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    @Override
    public TradeRoute getNewTradeRoute(Player player) {
        Game game = this.freeColServer.getGame();
        String name = "";
        return new TradeRoute(game, name, player);
    }

    @Override
    public boolean shouldCallNewTurn(FreeColGameObject freeColGameObject) {
        return true;
    }

    private static class TaskEntry {
        final String taskID;
        final int createdTurn;
        final Object entry;
        private boolean secure;
        private static final int TASK_ENTRY_TIME_OUT = 5;

        TaskEntry(String taskID, int createdTurn, boolean secure, Object entry) {
            this.taskID = taskID;
            this.createdTurn = createdTurn;
            this.secure = secure;
            this.entry = entry;
        }

        synchronized void setSecure(boolean secure) {
            this.secure = secure;
        }

        synchronized boolean isSecure() {
            return this.secure;
        }

        boolean hasExpired(int currentTurn) {
            return this.createdTurn + 5 < currentTurn;
        }
    }
}

