/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.IMapGenerator;
import net.sf.freecol.server.generator.LandGenerator;
import net.sf.freecol.server.generator.MapGeneratorOptions;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapGenerator
implements IMapGenerator {
    private static final Logger logger = Logger.getLogger(MapGenerator.class.getName());
    private final Random random;
    private final MapGeneratorOptions mapGeneratorOptions = new MapGeneratorOptions();
    private final LandGenerator landGenerator;
    private final TerrainGenerator terrainGenerator;
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;

    public MapGenerator() {
        this.random = new Random();
        this.landGenerator = new LandGenerator(this.mapGeneratorOptions);
        this.terrainGenerator = new TerrainGenerator(this.mapGeneratorOptions);
    }

    @Override
    public void createMap(Game game) throws FreeColException {
        File importFile = this.getMapGeneratorOptions().getFile("model.option.importFile");
        Game importGame = importFile != null ? this.loadSaveGame(importFile) : null;
        boolean[][] landMap = importGame != null ? LandGenerator.importLandMap(importGame) : this.landGenerator.createLandMap();
        this.terrainGenerator.createMap(game, importGame, landMap);
        Map map = game.getMap();
        this.createIndianSettlements(map, game.getPlayers());
        this.createEuropeanUnits(map, game.getPlayers());
        this.createLostCityRumours(map, importGame);
    }

    private Game loadSaveGame(File importFile) throws FreeColException {
        FreeColSavegameFile fis = null;
        Game game = null;
        try {
            fis = new FreeColSavegameFile(importFile);
            XMLStreamReader xsr = FreeColServer.createXMLStreamReader(fis);
            xsr.nextTag();
            String version = xsr.getAttributeValue(null, "version");
            if (!Message.getFreeColProtocolVersion().equals(version)) {
                throw new FreeColException("incompatibleVersions");
            }
            ArrayList<ServerPlayer> serverObjects = null;
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals("serverObjects")) {
                    serverObjects = new ArrayList<ServerPlayer>();
                    while (xsr.nextTag() != 2) {
                        if (xsr.getLocalName().equals(ServerPlayer.getServerAdditionXMLElementTagName())) {
                            serverObjects.add(new ServerPlayer(xsr));
                            continue;
                        }
                        throw new XMLStreamException("Unknown tag: " + xsr.getLocalName());
                    }
                    continue;
                }
                if (!xsr.getLocalName().equals(Game.getXMLElementTagName())) continue;
                game = new Game(null, null, xsr, serverObjects.toArray(new FreeColGameObject[serverObjects.size()]));
                game.setCurrentPlayer(null);
                game.checkIntegrity();
            }
            xsr.close();
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(e.toString());
        }
        catch (FreeColException fe) {
            StringWriter sw = new StringWriter();
            fe.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(fe.toString());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new FreeColException(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return game;
    }

    public LandGenerator getLandGenerator() {
        return this.landGenerator;
    }

    public TerrainGenerator getTerrainGenerator() {
        return this.terrainGenerator;
    }

    @Override
    public MapGeneratorOptions getMapGeneratorOptions() {
        return this.mapGeneratorOptions;
    }

    private void createLostCityRumours(Map map) {
        this.createLostCityRumours(map, null);
    }

    private void createLostCityRumours(Map map, Game importGame) {
        boolean importRumours = this.getMapGeneratorOptions().getBoolean("model.option.importRumours");
        if (importGame != null && importRumours) {
            for (Tile importTile : importGame.getMap().getAllTiles()) {
                Map.Position p = importTile.getPosition();
                if (!map.isValid(p)) continue;
                Tile t = map.getTile(p);
                t.setLostCityRumour(importTile.hasLostCityRumour());
            }
        } else {
            int number = this.getMapGeneratorOptions().getNumberOfRumours();
            int counter = 0;
            if (importGame != null) {
                number = map.getWidth() * map.getHeight() * 25 / 3500;
            }
            block1: for (int i = 0; i < number; ++i) {
                for (int tries = 0; tries < 100; ++tries) {
                    Map.Position p = new Map.Position(this.random.nextInt(map.getWidth()), this.random.nextInt(map.getHeight()));
                    if (p.y <= 2 || p.y >= map.getHeight() - 2 - 1) continue;
                    Tile t = map.getTile(p);
                    if (!map.getTile(p).isLand() || t.hasLostCityRumour() || t.getSettlement() != null || t.getUnitCount() != 0) continue;
                    ++counter;
                    t.setLostCityRumour(true);
                    continue block1;
                }
            }
            logger.info("Created " + counter + " lost city rumours of maximum " + number + ".");
        }
    }

    private void createIndianSettlements(final Map map, List<Player> players) {
        Territory territory;
        String name;
        int capitals;
        Tile tile2;
        float shares = 0.0f;
        ArrayList<Player> indians = new ArrayList<Player>();
        HashMap<String, Territory> territoryMap = new HashMap<String, Territory>();
        for (Player player : players) {
            if (!player.isIndian()) continue;
            switch (((IndianNationType)player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    shares += 4.0f;
                    break;
                }
                case AVERAGE: {
                    shares += 3.0f;
                    break;
                }
                case LOW: {
                    shares += 2.0f;
                }
            }
            indians.add(player);
            List<String> regionNames = ((IndianNationType)player.getNationType()).getRegionNames();
            Territory territory2 = null;
            if (regionNames == null || regionNames.isEmpty()) {
                territory2 = new Territory(player, map.getRandomLandPosition());
                territoryMap.put(player.getId(), territory2);
                continue;
            }
            for (String name2 : regionNames) {
                if (territoryMap.get(name2) != null) continue;
                ServerRegion region = (ServerRegion)map.getRegion(name2);
                territory2 = region == null ? new Territory(player, map.getRandomLandPosition()) : new Territory(player, region);
                territoryMap.put(name2, territory2);
                logger.fine("Allocated region " + name2 + " for " + player.getNationAsString() + ". Center is " + territory2.getCenter() + ".");
                break;
            }
            if (territory2 != null) continue;
            logger.warning("Failed to allocate preferred region " + regionNames.get(0) + " for " + player.getNation().getName());
            block12: for (String name2 : regionNames) {
                Territory otherTerritory = (Territory)territoryMap.get(name2);
                for (String otherName : ((IndianNationType)otherTerritory.player.getNationType()).getRegionNames()) {
                    if (territoryMap.get(otherName) != null) continue;
                    ServerRegion foundRegion = otherTerritory.region;
                    otherTerritory.region = (ServerRegion)map.getRegion(otherName);
                    territoryMap.put(otherName, otherTerritory);
                    territory2 = new Territory(player, foundRegion);
                    territoryMap.put(name2, territory2);
                    break block12;
                }
            }
            if (territory2 != null) continue;
            logger.warning("Unable to find free region for " + player.getName());
            territory2 = new Territory(player, map.getRandomLandPosition());
            territoryMap.put(player.getId(), territory2);
        }
        if (indians.isEmpty()) {
            return;
        }
        ArrayList<Territory> territories = new ArrayList<Territory>(territoryMap.values());
        ArrayList<Tile> settlementTiles = new ArrayList<Tile>();
        int minSettlementDistance = 3;
        int level = map.getGame().getGameOptions().getInteger("model.option.difficulty");
        int number = this.mapGeneratorOptions.getNumberOfSettlements() * Specification.getSpecification().getIntegerOption("model.option.nativeSettlementDensity").getValue() / 100;
        block14: for (int i = 0; i < number; ++i) {
            block15: for (int tries = 0; tries < 100; ++tries) {
                Tile candidate;
                Map.Position position = map.getRandomLandPosition();
                if (position.getY() <= 2 || position.getY() >= map.getHeight() - 2 - 1 || !(candidate = map.getTile(position)).isSettleable()) continue;
                for (Tile tile2 : settlementTiles) {
                    if (map.getDistance(position, tile2.getPosition()) >= 3) continue;
                    continue block15;
                }
                settlementTiles.add(candidate);
                continue block14;
            }
        }
        int potential = settlementTiles.size();
        if (potential < (capitals = indians.size())) {
            logger.warning("Number of potential settlements is smaller than number of tribes.");
            capitals = potential;
        }
        float share = (float)settlementTiles.size() / shares;
        int counter = 0;
        for (Territory territory3 : territories) {
            switch (((IndianNationType)territory3.player.getNationType()).getNumberOfSettlements()) {
                case HIGH: {
                    territory3.numberOfSettlements = Math.round(4.0f * share);
                    break;
                }
                case AVERAGE: {
                    territory3.numberOfSettlements = Math.round(3.0f * share);
                    break;
                }
                case LOW: {
                    territory3.numberOfSettlements = Math.round(2.0f * share);
                }
            }
            Tile tile3 = this.getClosestTile(map, territory3.getCenter(), settlementTiles);
            if (tile3 == null) break;
            name = "default region";
            if (territory3.region != null) {
                name = territory3.region.getNameKey();
            }
            logger.fine("Placing the " + territory3.player.getNationAsString() + " capital in region: " + name + " at Tile: " + tile3.getPosition());
            this.placeIndianSettlement(territory3.player, true, tile3.getPosition(), map);
            --territory3.numberOfSettlements;
            territory3.position = tile3.getPosition();
            settlementTiles.remove(tile3);
            ++counter;
        }
        Collections.sort(settlementTiles, new Comparator<Tile>(){

            @Override
            public int compare(Tile tile1, Tile tile2) {
                int distance1 = Math.min(Math.min(tile1.getX(), map.getWidth() - tile1.getX()), Math.min(tile1.getY(), map.getHeight() - tile1.getY()));
                int distance2 = Math.min(Math.min(tile2.getX(), map.getWidth() - tile2.getX()), Math.min(tile2.getY(), map.getHeight() - tile2.getY()));
                return distance1 - distance2;
            }
        });
        Iterator i$ = settlementTiles.iterator();
        while (i$.hasNext() && (territory = this.getClosestTerritory(map, tile2 = (Tile)i$.next(), territories)) != null) {
            name = "default region";
            if (territory.region != null) {
                name = territory.region.getNameKey();
            }
            logger.fine("Placing a " + territory.player.getNationAsString() + " camp in region: " + name + " at Tile: " + tile2.getPosition());
            this.placeIndianSettlement(territory.player, false, tile2.getPosition(), map);
            ++counter;
            if (territory.numberOfSettlements < 2) {
                territories.remove(territory);
                continue;
            }
            --territory.numberOfSettlements;
        }
        logger.info("Created " + counter + " Indian settlements of maximum " + potential);
    }

    private Tile getClosestTile(Map map, Map.Position center, List<Tile> tiles) {
        Tile result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Tile tile : tiles) {
            int distance = map.getDistance(tile.getPosition(), center);
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = tile;
        }
        return result;
    }

    private Territory getClosestTerritory(Map map, Tile tile, List<Territory> territories) {
        Territory result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Territory territory : territories) {
            int distance = map.getDistance(tile.getPosition(), territory.getCenter());
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = territory;
        }
        return result;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Map.Position position, Map map) {
        Tile tile = map.getTile(position);
        IndianSettlement settlement = new IndianSettlement(map.getGame(), player, tile, capital, this.generateSkillForLocation(map, tile, player.getNationType()), new HashSet<Player>(), null);
        Settlement.SettlementType kind = settlement.getTypeOfSettlement();
        logger.fine("Generated skill: " + settlement.getLearnableSkill().getName());
        tile.setSettlement(settlement);
        tile.setOwningSettlement(settlement);
        Map.CircleIterator circleIterator = map.getCircleIterator(position, true, settlement.getRadius());
        while (circleIterator.hasNext()) {
            Tile newTile = map.getTile((Map.Position)circleIterator.next());
            newTile.setOwningSettlement(settlement);
            newTile.setOwner(player);
        }
        int unitCount = settlement.getGeneratedUnitCount();
        for (int i = 0; i < unitCount; ++i) {
            UnitType unitType = FreeCol.getSpecification().getUnitType("model.unit.brave");
            Unit unit = new Unit(map.getGame(), settlement, player, unitType, Unit.UnitState.ACTIVE, unitType.getDefaultEquipment());
            unit.setIndianSettlement(settlement);
            if (i == 0) {
                unit.setLocation(tile);
                continue;
            }
            unit.setLocation(settlement);
        }
        if (FreeCol.isInDebugMode()) {
            for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isNewWorldGoodsType()) continue;
                settlement.addGoods(goodsType, 150);
            }
        }
        return settlement;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> skill : skills) {
            scale.put(skill.getObject().getExpertProduction(), 1);
        }
        Iterator<Map.Position> iter = map.getAdjacentIterator(tile.getPosition());
        while (iter.hasNext()) {
            Map.Position p = iter.next();
            Tile t = map.getTile(p);
            for (GoodsType goodsType : scale.keySet()) {
                scale.put(goodsType, (Integer)scale.get(goodsType) + t.potential(goodsType, null));
            }
        }
        ArrayList scaledSkills = new ArrayList();
        for (RandomChoice<UnitType> skill : skills) {
            UnitType unitType = skill.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill.getProbability() * scaleValue));
        }
        UnitType skill = (UnitType)RandomChoice.getWeightedRandom(this.random, scaledSkills);
        if (skill == null) {
            List<UnitType> unitList = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            return unitList.get(this.random.nextInt(unitList.size()));
        }
        return skill;
    }

    private void createEuropeanUnits(Map map, List<Player> players) {
        int width = map.getWidth();
        int height = map.getHeight();
        int poleDistance = (int)(0.3f * (float)height / 2.0f);
        ArrayList<Player> europeanPlayers = new ArrayList<Player>();
        for (Player player : players) {
            if (player.isREF()) {
                int x = width - 2;
                int y = this.random.nextInt(height - 2 * poleDistance) + poleDistance;
                player.setEntryLocation(map.getTile(x, y));
                continue;
            }
            if (!player.isEuropean()) continue;
            europeanPlayers.add(player);
            logger.finest("found European player " + player.getNationAsString());
        }
        int startingPositions = europeanPlayers.size();
        ArrayList<Integer> startingYPositions = new ArrayList<Integer>();
        for (Player player : europeanPlayers) {
            int y;
            logger.fine("generating units for player " + player.getNationAsString());
            ArrayList<Unit> carriers = new ArrayList<Unit>();
            ArrayList<Unit> passengers = new ArrayList<Unit>();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                Unit newUnit = new Unit(map.getGame(), null, player, startingUnit.getUnitType(), Unit.UnitState.SENTRY, startingUnit.getEquipment());
                if (newUnit.canCarryUnits() && newUnit.isNaval()) {
                    newUnit.setState(Unit.UnitState.ACTIVE);
                    carriers.add(newUnit);
                    continue;
                }
                passengers.add(newUnit);
            }
            boolean startAtSea = true;
            if (carriers.isEmpty()) {
                logger.warning("No carriers defined for player " + player.getNationAsString());
                startAtSea = false;
            }
            int x = width - 1;
            while (map.getTile(x, y = this.random.nextInt(height - poleDistance * 2) + poleDistance).isLand() == startAtSea || this.isStartingPositionTooClose(map, y, startingPositions, startingYPositions)) {
            }
            startingYPositions.add(new Integer(y));
            if (startAtSea) {
                while (map.getTile(x - 1, y).canMoveToEurope()) {
                    --x;
                }
            }
            Tile startTile = map.getTile(x, y);
            startTile.setExploredBy(player, true);
            player.setEntryLocation(startTile);
            if (startAtSea) {
                for (Unit carrier : carriers) {
                    carrier.setLocation(startTile);
                }
                block6: for (Unit unit : passengers) {
                    for (Unit carrier : carriers) {
                        if (carrier.getSpaceLeft() < unit.getSpaceTaken()) continue;
                        unit.setLocation(carrier);
                        continue block6;
                    }
                    unit.setLocation(player.getEurope());
                }
            } else {
                for (Unit unit : passengers) {
                    unit.setLocation(startTile);
                }
            }
            if (!FreeCol.isInDebugMode()) continue;
            UnitType unitType = FreeCol.getSpecification().getUnitType("model.unit.galleon");
            Unit unit4 = new Unit(map.getGame(), startTile, player, unitType, Unit.UnitState.ACTIVE);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.privateer");
            Unit privateer = new Unit(map.getGame(), startTile, player, unitType, Unit.UnitState.ACTIVE);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.freeColonist");
            Unit unit5 = new Unit(map.getGame(), unit4, player, unitType, Unit.UnitState.SENTRY);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.veteranSoldier");
            Unit unit6 = new Unit(map.getGame(), unit4, player, unitType, Unit.UnitState.SENTRY);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.jesuitMissionary");
            Unit unit7 = new Unit(map.getGame(), unit4, player, unitType, Unit.UnitState.SENTRY);
            Tile colonyTile = null;
            Iterator<Map.Position> cti = map.getFloodFillIterator(new Map.Position(x, y));
            while (cti.hasNext()) {
                Tile tempTile = map.getTile(cti.next());
                if (tempTile.getY() <= 2 || tempTile.getY() >= map.getHeight() - 2 - 1 || !tempTile.isColonizeable()) continue;
                colonyTile = tempTile;
                break;
            }
            if (colonyTile == null) continue;
            for (TileType t : FreeCol.getSpecification().getTileTypeList()) {
                if (t.isWater()) continue;
                colonyTile.setType(t);
                break;
            }
            unitType = FreeCol.getSpecification().getUnitType("model.unit.expertFarmer");
            Unit buildColonyUnit = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            String colonyName = player.getNationAsString() + " Colony";
            Colony colony = new Colony(map.getGame(), player, colonyName, colonyTile);
            buildColonyUnit.buildColony(colony);
            if (buildColonyUnit.getLocation() instanceof ColonyTile) {
                Tile ct = ((ColonyTile)buildColonyUnit.getLocation()).getWorkTile();
                for (TileType t : FreeCol.getSpecification().getTileTypeList()) {
                    if (t.isWater()) continue;
                    ct.setType(t);
                    break;
                }
            }
            BuildingType schoolType = FreeCol.getSpecification().getBuildingType("model.building.Schoolhouse");
            Building schoolhouse = new Building(map.getGame(), colony, schoolType);
            colony.addBuilding(schoolhouse);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.masterCarpenter");
            while (!schoolhouse.canAdd(unitType)) {
                schoolhouse.upgrade();
            }
            Unit carpenter = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            carpenter.setLocation(colony.getBuildingForProducing(unitType.getExpertProduction()));
            unitType = FreeCol.getSpecification().getUnitType("model.unit.elderStatesman");
            Unit statesman = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            statesman.setLocation(colony.getBuildingForProducing(unitType.getExpertProduction()));
            unitType = FreeCol.getSpecification().getUnitType("model.unit.expertLumberJack");
            Unit lumberjack = new Unit(map.getGame(), colony, player, unitType, Unit.UnitState.ACTIVE);
            if (lumberjack.getLocation() instanceof ColonyTile) {
                Tile lt = ((ColonyTile)lumberjack.getLocation()).getWorkTile();
                for (TileType t : FreeCol.getSpecification().getTileTypeList()) {
                    if (!t.isForested()) continue;
                    lt.setType(t);
                    break;
                }
                lumberjack.setWorkType(lumberjack.getType().getExpertProduction());
            }
            unitType = FreeCol.getSpecification().getUnitType("model.unit.seasonedScout");
            Unit scout = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.veteranSoldier");
            Unit unit8 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            Unit unit9 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.artillery");
            Unit unit10 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            Unit unit11 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            Unit unit12 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.treasureTrain");
            Unit unit13 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            unit13.setTreasureAmount(10000);
            unitType = FreeCol.getSpecification().getUnitType("model.unit.wagonTrain");
            Unit unit14 = new Unit(map.getGame(), colonyTile, player, unitType, Unit.UnitState.ACTIVE);
            GoodsType cigarsType = FreeCol.getSpecification().getGoodsType("model.goods.cigars");
            Goods cigards = new Goods(map.getGame(), unit14, cigarsType, 5);
            unit14.add(cigards);
        }
    }

    private boolean isStartingPositionTooClose(Map map, int proposedY, int startingPositions, List<Integer> usedYPositions) {
        int poleDistance = (int)(0.3f * (float)map.getHeight() / 2.0f);
        int spawnableRange = map.getHeight() - poleDistance * 2;
        int minimumDistance = spawnableRange / (startingPositions * 2);
        for (Integer yPosition : usedYPositions) {
            if (Math.abs(yPosition - proposedY) >= minimumDistance) continue;
            return true;
        }
        return false;
    }

    private class Territory {
        public ServerRegion region;
        public Map.Position position;
        public Player player;
        public int numberOfSettlements;

        public Territory(Player player, Map.Position position) {
            this.player = player;
            this.position = position;
        }

        public Territory(Player player, ServerRegion region) {
            this.player = player;
            this.region = region;
        }

        public Map.Position getCenter() {
            if (this.position == null) {
                return this.region.getCenter();
            }
            return this.position;
        }

        public String toString() {
            return this.player.getNationAsString() + " territory at " + this.region.toString();
        }
    }
}

