/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.option.OptionMap;
import org.w3c.dom.Element;

public class MapGeneratorOptions
extends OptionMap {
    public static final String MAP_SIZE = "model.option.mapSize";
    public static final int MAP_SIZE_SMALL = 0;
    public static final int MAP_SIZE_MEDIUM = 1;
    public static final int MAP_SIZE_LARGE = 2;
    public static final int MAP_SIZE_VERY_LARGE = 3;
    public static final int MAP_SIZE_HUGE = 4;
    public static final String LAND_MASS = "model.option.landMass";
    public static final String RIVER_NUMBER = "model.option.riverNumber";
    public static final String MOUNTAIN_NUMBER = "model.option.mountainNumber";
    public static final String RUMOUR_NUMBER = "model.option.rumourNumber";
    public static final String SETTLEMENT_NUMBER = "model.option.settlementNumber";
    public static final String FOREST_NUMBER = "model.option.forestNumber";
    public static final String BONUS_NUMBER = "model.option.bonusNumber";
    public static final String HUMIDITY = "model.option.humidity";
    public static final String TEMPERATURE = "model.option.temperature";
    public static final int TEMPERATURE_COLD = 0;
    public static final int TEMPERATURE_CHILLY = 1;
    public static final int TEMPERATURE_TEMPERATE = 2;
    public static final int TEMPERATURE_WARM = 3;
    public static final int TEMPERATURE_HOT = 4;
    public static final String IMPORT_FILE = "model.option.importFile";
    public static final String IMPORT_TERRAIN = "model.option.importTerrain";
    public static final String IMPORT_BONUSES = "model.option.importBonuses";
    public static final String IMPORT_RUMOURS = "model.option.importRumours";
    public static final String IMPORT_SETTLEMENTS = "model.option.importSettlements";
    public static final String LAND_GEN_TYPE = "model.option.landGeneratorType";
    public static final int LAND_GEN_CLASSIC = 0;
    public static final int LAND_GEN_CONTINENT = 1;
    public static final int LAND_GEN_ARCHIPELAGO = 2;
    public static final int LAND_GEN_ISLANDS = 3;

    public MapGeneratorOptions() {
        super(MapGeneratorOptions.getXMLElementTagName());
    }

    public MapGeneratorOptions(Element element) {
        super(element, MapGeneratorOptions.getXMLElementTagName());
    }

    public MapGeneratorOptions(XMLStreamReader in) throws XMLStreamException {
        super(in, MapGeneratorOptions.getXMLElementTagName());
    }

    protected void addDefaultOptions() {
        Specification spec = Specification.getSpecification();
        this.add(spec.getOptionGroup("mapGeneratorOptions.import"));
        Map<Integer, String> mapSizeValues = spec.getRangeOption(MAP_SIZE).getItemValues();
        Map<Integer, String> landMassValues = spec.getRangeOption(LAND_MASS).getItemValues();
        if (!mapSizeValues.get(0).substring(0, 1).equals("<")) {
            for (int index : mapSizeValues.keySet()) {
                mapSizeValues.put(index, "<html><center>" + mapSizeValues.get(index) + "<br/>(" + this.getWidth(index) + "\u00d7" + this.getHeight(index) + ")</center></html>");
            }
            for (int index : landMassValues.keySet()) {
                landMassValues.put(index, "<html><center>" + landMassValues.get(index) + "<br/>(" + index + "%)</center></html>");
            }
        }
        this.add(spec.getOptionGroup("mapGeneratorOptions.landGenerator"));
        this.add(spec.getOptionGroup("mapGeneratorOptions.terrainGenerator"));
    }

    public int getWidth() {
        return this.getWidth(this.getInteger(MAP_SIZE));
    }

    private int getWidth(int size) {
        switch (size) {
            case 0: {
                return 28;
            }
            case 1: {
                return 28;
            }
            case 2: {
                return 37;
            }
            case 3: {
                return 46;
            }
            case 4: {
                return 55;
            }
        }
        throw new IllegalStateException("Invalid map-size: " + size + ".");
    }

    public int getHeight() {
        return this.getHeight(this.getInteger(MAP_SIZE));
    }

    private int getHeight(int size) {
        switch (size) {
            case 0: {
                return 65;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 192;
            }
            case 3: {
                return 257;
            }
            case 4: {
                return 321;
            }
        }
        throw new IllegalStateException("Invalid map-size: " + size + ".");
    }

    public int getLandMass() {
        return Specification.getSpecification().getRangeOption(LAND_MASS).getValue();
    }

    public int getLand() {
        return this.getWidth() * this.getHeight() * this.getLandMass() / 100;
    }

    public int getLandGeneratorType() {
        return Specification.getSpecification().getRangeOption(LAND_GEN_TYPE).getValue();
    }

    public int getNumberOfRivers() {
        return this.getLand() / Specification.getSpecification().getRangeOption(RIVER_NUMBER).getValue();
    }

    public int getNumberOfMountainTiles() {
        return this.getLand() / Specification.getSpecification().getRangeOption(MOUNTAIN_NUMBER).getValue();
    }

    public int getNumberOfRumours() {
        return this.getLand() / Specification.getSpecification().getRangeOption(RUMOUR_NUMBER).getValue();
    }

    public int getNumberOfSettlements() {
        return this.getLand() / Specification.getSpecification().getRangeOption(SETTLEMENT_NUMBER).getValue();
    }

    public int getPercentageOfForests() {
        return Specification.getSpecification().getRangeOption(FOREST_NUMBER).getValue();
    }

    public int getPercentageOfBonusTiles() {
        return Specification.getSpecification().getRangeOption(BONUS_NUMBER).getValue();
    }

    public int getDistLandHighSea() {
        int size = this.getInteger(MAP_SIZE);
        switch (size) {
            case 0: {
                return 4;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalStateException("Invalid map-size: " + size + ".");
    }

    public int getMaxDistToEdge() {
        int size = this.getInteger(MAP_SIZE);
        switch (size) {
            case 0: {
                return 12;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 12;
            }
        }
        throw new IllegalStateException("Invalid map-size: " + size + ".");
    }

    public int getPrefDistToEdge() {
        int size = this.getInteger(MAP_SIZE);
        switch (size) {
            case 0: {
                return 5;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 5;
            }
        }
        throw new IllegalStateException("Invalid map-size: " + size + ".");
    }

    public int getHumidity() {
        return Specification.getSpecification().getRangeOption(HUMIDITY).getValue();
    }

    public int getTemperature() {
        return Specification.getSpecification().getRangeOption(TEMPERATURE).getValue();
    }

    protected boolean isCorrectTagName(String tagName) {
        return MapGeneratorOptions.getXMLElementTagName().equals(tagName);
    }

    public static String getXMLElementTagName() {
        return "mapGeneratorOptions";
    }
}

