/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.RiverSection;
import net.sf.freecol.server.model.ServerRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class River {
    private static final Logger logger = Logger.getLogger(MapGenerator.class.getName());
    private static final TileType greatRiver = FreeCol.getSpecification().getTileType("model.tile.greatRiver");
    public static final Map.Direction[] directions = new Map.Direction[]{Map.Direction.NE, Map.Direction.SE, Map.Direction.SW, Map.Direction.NW};
    private Map.Direction direction;
    private net.sf.freecol.common.model.Map map;
    private List<RiverSection> sections = new ArrayList<RiverSection>();
    private River nextRiver = null;
    private ServerRegion region;
    private Map<Map.Position, River> riverMap;
    private boolean connected = false;

    public River(net.sf.freecol.common.model.Map map, Map<Map.Position, River> riverMap, ServerRegion region) {
        this.map = map;
        this.riverMap = riverMap;
        this.region = region;
        int length = directions.length;
        int index = map.getGame().getModelController().getPseudoRandom().nextInt(length);
        this.direction = directions[index];
        logger.fine("Starting new river flowing " + this.direction.toString());
    }

    public List<RiverSection> getSections() {
        return this.sections;
    }

    public int getLength() {
        return this.sections.size();
    }

    public RiverSection getLastSection() {
        return this.sections.get(this.sections.size() - 1);
    }

    public final ServerRegion getRegion() {
        return this.region;
    }

    public final void setRegion(ServerRegion newServerRegion) {
        this.region = newServerRegion;
    }

    public void add(Map.Position position, Map.Direction direction) {
        this.sections.add(new RiverSection(position, direction));
    }

    public void grow(RiverSection lastSection, Map.Position position) {
        boolean found = false;
        for (RiverSection section : this.sections) {
            if (found) {
                section.grow();
                continue;
            }
            if (!section.getPosition().equals(position)) continue;
            section.setBranch(lastSection.direction.getReverseDirection(), lastSection.getSize());
            section.grow();
            found = true;
        }
        this.drawToMap();
        if (this.nextRiver != null) {
            RiverSection section = this.sections.get(this.sections.size() - 1);
            Map.Position neighbor = net.sf.freecol.common.model.Map.getAdjacent(section.getPosition(), section.direction);
            this.nextRiver.grow(section, neighbor);
        }
    }

    public boolean isNextToSelf(Map.Position p) {
        for (Map.Direction direction : directions) {
            Map.Position px = net.sf.freecol.common.model.Map.getAdjacent(p, direction);
            if (!this.contains(px)) continue;
            return true;
        }
        return false;
    }

    public boolean isNextToWater(Map.Position p) {
        for (Map.Direction direction : directions) {
            Map.Position px = net.sf.freecol.common.model.Map.getAdjacent(p, direction);
            Tile tile = this.map.getTile(px);
            if (tile == null || tile.isLand() && !tile.hasRiver()) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Map.Position p) {
        Iterator<RiverSection> sectionIterator = this.sections.iterator();
        while (sectionIterator.hasNext()) {
            Map.Position q = sectionIterator.next().getPosition();
            if (!p.equals(q)) continue;
            return true;
        }
        return false;
    }

    public boolean flowFromSource(Map.Position position) {
        Tile tile = this.map.getTile(position);
        if (!tile.getType().canHaveRiver()) {
            logger.fine("Tile (" + tile.getType().getName() + ") at " + position + " cannot have rivers.");
            return false;
        }
        if (this.isNextToWater(position)) {
            logger.fine("Tile at " + position + " is next to water.");
            return false;
        }
        logger.fine("Tile at " + position + " is suitable source.");
        return this.flow(position);
    }

    private boolean flow(Map.Position source) {
        if (this.sections.size() % 2 == 0) {
            int length = DirectionChange.values().length;
            int index = this.map.getGame().getModelController().getPseudoRandom().nextInt(length);
            DirectionChange change = DirectionChange.values()[index];
            this.direction = change.getNewDirection(this.direction);
            logger.fine("Direction is now " + (Object)((Object)this.direction));
        }
        for (DirectionChange change : DirectionChange.values()) {
            Map.Direction dir = change.getNewDirection(this.direction);
            Map.Position newPosition = net.sf.freecol.common.model.Map.getAdjacent(source, dir);
            Tile nextTile = this.map.getTile(newPosition);
            if (nextTile == null) continue;
            if (!nextTile.getType().canHaveRiver()) {
                logger.fine("Tile (" + nextTile.getType().getName() + ") at " + newPosition + " cannot have rivers.");
                continue;
            }
            if (this.contains(newPosition)) {
                logger.fine("Tile at " + newPosition + " is already in river.");
                continue;
            }
            if (this.isNextToSelf(newPosition)) {
                logger.fine("Tile at " + newPosition + " is next to the river.");
                continue;
            }
            for (DirectionChange change2 : DirectionChange.values()) {
                Map.Direction lastDir = change2.getNewDirection(dir);
                Map.Position px = net.sf.freecol.common.model.Map.getAdjacent(newPosition, lastDir);
                Tile tile = this.map.getTile(px);
                if (tile == null || tile.isLand() && !tile.hasRiver()) continue;
                this.sections.add(new RiverSection(source, dir));
                RiverSection lastSection = new RiverSection(newPosition, lastDir);
                this.sections.add(lastSection);
                if (tile.hasRiver() && tile.isLand()) {
                    logger.fine("Point " + newPosition + " is next to another river.");
                    this.drawToMap();
                    this.nextRiver = this.riverMap.get(px);
                    this.nextRiver.grow(lastSection, px);
                } else {
                    logger.fine("Point " + newPosition + " is next to water.");
                    River someRiver = this.riverMap.get(px);
                    if (someRiver == null) {
                        this.sections.add(new RiverSection(px, lastDir.getReverseDirection()));
                    } else {
                        RiverSection waterSection = someRiver.getLastSection();
                        waterSection.setBranch(lastDir.getReverseDirection(), 1);
                    }
                    this.connected = tile.isConnected();
                    this.drawToMap();
                }
                return true;
            }
            logger.fine("Tile at " + newPosition + " is suitable.");
            this.sections.add(new RiverSection(source, dir));
            return this.flow(newPosition);
        }
        this.sections = new ArrayList<RiverSection>();
        return false;
    }

    private void drawToMap() {
        RiverSection oldSection = null;
        for (RiverSection section : this.sections) {
            Tile tile;
            this.riverMap.put(section.getPosition(), this);
            if (oldSection != null) {
                section.setBranch(oldSection.direction.getReverseDirection(), oldSection.getSize());
            }
            if (!(tile = this.map.getTile(section.getPosition())).isLand()) continue;
            TileItemContainer container = tile.getTileItemContainer();
            if (container == null) {
                container = new TileItemContainer(tile.getGame(), tile);
                tile.setTileItemContainer(container);
            }
            if (section.getSize() == 1 || section.getSize() == 2) {
                container.addRiver(section.getSize(), section.encodeStyle());
                logger.fine("Added river (magnitude: " + section.getSize() + ") to tile at " + section.getPosition());
            } else if (section.getSize() >= 3) {
                tile.setType(greatRiver);
                container.addRiver(section.getSize(), section.encodeStyle());
                if (this.connected) {
                    tile.setConnected(true);
                }
                logger.fine("Added fjord (magnitude: " + section.getSize() + ") to tile at " + section.getPosition());
            }
            this.region.addTile(tile);
            oldSection = section;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DirectionChange {
        STRAIGHT_AHEAD,
        RIGHT_TURN,
        LEFT_TURN;


        public Map.Direction getNewDirection(Map.Direction oldDirection) {
            switch (this) {
                case STRAIGHT_AHEAD: {
                    return oldDirection;
                }
                case RIGHT_TURN: {
                    switch (oldDirection) {
                        case NE: {
                            return Map.Direction.SE;
                        }
                        case SE: {
                            return Map.Direction.SW;
                        }
                        case SW: {
                            return Map.Direction.NW;
                        }
                        case NW: {
                            return Map.Direction.NE;
                        }
                    }
                    return oldDirection;
                }
                case LEFT_TURN: {
                    switch (oldDirection) {
                        case NE: {
                            return Map.Direction.NW;
                        }
                        case SE: {
                            return Map.Direction.NE;
                        }
                        case SW: {
                            return Map.Direction.SE;
                        }
                        case NW: {
                            return Map.Direction.SW;
                        }
                    }
                    return oldDirection;
                }
            }
            return oldDirection;
        }
    }
}

