/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.generator.MapGeneratorOptions;
import net.sf.freecol.server.generator.River;
import net.sf.freecol.server.generator.RiverSection;
import net.sf.freecol.server.model.ServerRegion;

public class TerrainGenerator {
    private static final Logger logger = Logger.getLogger(TerrainGenerator.class.getName());
    public static final int LAND_REGIONS_SCORE_VALUE = 1000;
    public static final int LAND_REGION_MIN_SCORE = 5;
    public static final int PACIFIC_SCORE_VALUE = 100;
    public static final int LAND_REGION_MAX_SIZE = 75;
    private final MapGeneratorOptions mapGeneratorOptions;
    private final Random random = new Random();
    private TileType ocean = FreeCol.getSpecification().getTileType("model.tile.ocean");
    private TileType lake = FreeCol.getSpecification().getTileType("model.tile.lake");
    private ArrayList<TileType> terrainTileTypes = null;

    public TerrainGenerator(MapGeneratorOptions mapGeneratorOptions) {
        this.mapGeneratorOptions = mapGeneratorOptions;
    }

    public void createMap(Game game, boolean[][] landMap) {
        this.createMap(game, null, landMap);
    }

    public void createMap(Game game, Game importGame, boolean[][] landMap) {
        int width = landMap.length;
        int height = landMap[0].length;
        boolean importTerrain = importGame != null && this.getMapGeneratorOptions().getBoolean("model.option.importTerrain");
        boolean importBonuses = importGame != null && this.getMapGeneratorOptions().getBoolean("model.option.importBonuses");
        boolean mapHasLand = false;
        Tile[][] tiles = new Tile[width][height];
        for (int y = 0; y < height; ++y) {
            int latitude = Math.min(y, height - 1 - y) * 200 / height;
            for (int x = 0; x < width; ++x) {
                Tile t;
                if (landMap[x][y]) {
                    mapHasLand = true;
                }
                if (importTerrain && importGame.getMap().isValid(x, y)) {
                    Tile importTile = importGame.getMap().getTile(x, y);
                    if (importTile.isLand() == landMap[x][y]) {
                        t = new Tile(game, importTile.getType(), x, y);
                        if (importTile.getTileItemContainer() != null) {
                            TileItemContainer container = new TileItemContainer(game, t);
                            container.copyFrom(importTile.getTileItemContainer(), importBonuses);
                            t.setTileItemContainer(container);
                        }
                    } else {
                        t = this.createTile(game, x, y, landMap, latitude);
                    }
                } else {
                    t = this.createTile(game, x, y, landMap, latitude);
                }
                tiles[x][y] = t;
            }
        }
        Map map = new Map(game, tiles);
        game.setMap(map);
        if (!importTerrain) {
            this.createOceanRegions(map);
            this.createHighSeas(map);
            if (mapHasLand) {
                this.createMountains(map);
                this.findLakes(map);
                this.createRivers(map);
                this.createLandRegions(map);
            }
        }
        Map.WholeMapIterator iterator = map.getWholeMapIterator();
        while (iterator.hasNext()) {
            Tile tile = map.getTile(iterator.next());
            this.perhapsAddBonus(tile, !importBonuses);
        }
    }

    private Tile createTile(Game game, int x, int y, boolean[][] landMap, int latitude) {
        Tile t = landMap[x][y] ? new Tile(game, this.getRandomLandTileType(latitude), x, y) : new Tile(game, this.ocean, x, y);
        return t;
    }

    private void perhapsAddBonus(Tile t, boolean generateBonus) {
        if (t.isLand()) {
            if (generateBonus && this.random.nextInt(100) < this.getMapGeneratorOptions().getPercentageOfBonusTiles()) {
                t.setResource((ResourceType)RandomChoice.getWeightedRandom(this.random, t.getType().getWeightedResources()));
            }
        } else {
            int adjacentLand = 0;
            int riverBonus = 0;
            int fishBonus = 0;
            boolean adjacentRiver = false;
            for (Map.Direction direction : Map.Direction.values()) {
                Tile otherTile = t.getMap().getNeighbourOrNull(direction, t);
                if (otherTile == null || !otherTile.isLand()) continue;
                ++adjacentLand;
                if (!otherTile.hasRiver()) continue;
                adjacentRiver = true;
                riverBonus = Math.max(riverBonus, otherTile.getRiver().getMagnitude());
            }
            if (adjacentLand > 2) {
                fishBonus += 2;
            }
            if (!t.hasRiver() && adjacentRiver) {
                fishBonus += riverBonus;
            }
            t.setFishBonus(fishBonus);
            t.setLandCount(adjacentLand);
            if (t.getType().isConnected()) {
                if (generateBonus && adjacentLand > 1 && this.random.nextInt(10 - adjacentLand) == 0) {
                    t.setResource((ResourceType)RandomChoice.getWeightedRandom(this.random, t.getType().getWeightedResources()));
                }
            } else if (this.random.nextInt(100) < this.getMapGeneratorOptions().getPercentageOfBonusTiles()) {
                t.setResource((ResourceType)RandomChoice.getWeightedRandom(this.random, t.getType().getWeightedResources()));
            }
        }
    }

    private MapGeneratorOptions getMapGeneratorOptions() {
        return this.mapGeneratorOptions;
    }

    private TileType getRandomLandTileType(int latitudePercent) {
        TileType t;
        int forestChance = this.getMapGeneratorOptions().getPercentageOfForests();
        int temperaturePreference = this.getMapGeneratorOptions().getTemperature();
        if (this.terrainTileTypes == null) {
            this.terrainTileTypes = new ArrayList();
            for (TileType tileType : FreeCol.getSpecification().getTileTypeList()) {
                if (tileType.getId().equals("model.tile.hills") || tileType.getId().equals("model.tile.mountains") || tileType.isWater()) continue;
                this.terrainTileTypes.add(tileType);
            }
        }
        int poleTemperature = -20;
        int equatorTemperature = 40;
        if (temperaturePreference == 0) {
            poleTemperature = -20;
            equatorTemperature = 25;
        } else if (temperaturePreference == 1) {
            poleTemperature = -20;
            equatorTemperature = 30;
        } else if (temperaturePreference == 2) {
            poleTemperature = -10;
            equatorTemperature = 35;
        } else if (temperaturePreference == 3) {
            poleTemperature = -5;
            equatorTemperature = 40;
        } else if (temperaturePreference == 4) {
            poleTemperature = 0;
            equatorTemperature = 40;
        }
        int temperatureRange = equatorTemperature - poleTemperature;
        int localeTemperature = poleTemperature + latitudePercent * temperatureRange / 100;
        int temperatureDeviation = 7;
        if ((localeTemperature += this.random.nextInt(temperatureDeviation * 2) - temperatureDeviation) > 40) {
            localeTemperature = 40;
        }
        if (localeTemperature < -20) {
            localeTemperature = -20;
        }
        int localeHumidity = Specification.getSpecification().getRangeOption("model.option.humidity").getValue();
        int humidityDeviation = 20;
        if ((localeHumidity += this.random.nextInt(humidityDeviation * 2) - humidityDeviation) < 0) {
            localeHumidity = 0;
        }
        if (localeHumidity > 100) {
            localeHumidity = 100;
        }
        ArrayList<TileType> candidateTileTypes = new ArrayList<TileType>();
        candidateTileTypes.addAll(this.terrainTileTypes);
        Iterator it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            t = (TileType)it.next();
            if (t.withinRange(TileType.RangeType.TEMPERATURE, localeTemperature)) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature);
        }
        it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            t = (TileType)it.next();
            if (t.withinRange(TileType.RangeType.HUMIDITY, localeHumidity)) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature + " and humidity==" + localeHumidity);
        }
        boolean forested = this.random.nextInt(100) < forestChance;
        it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            TileType t2 = (TileType)it.next();
            if (t2.isForested() == forested) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature + " and humidity==" + localeHumidity + " and forested==" + forested);
        }
        return (TileType)candidateTileTypes.get(this.random.nextInt(candidateTileTypes.size()));
    }

    private void createOceanRegions(Map map) {
        Game game = map.getGame();
        ServerRegion pacific = new ServerRegion(game, "model.region.pacific", Region.RegionType.OCEAN);
        ServerRegion northPacific = new ServerRegion(game, "model.region.northPacific", Region.RegionType.OCEAN, pacific);
        ServerRegion southPacific = new ServerRegion(game, "model.region.southPacific", Region.RegionType.OCEAN, pacific);
        ServerRegion atlantic = new ServerRegion(game, "model.region.atlantic", Region.RegionType.OCEAN);
        ServerRegion northAtlantic = new ServerRegion(game, "model.region.northAtlantic", Region.RegionType.OCEAN, atlantic);
        ServerRegion southAtlantic = new ServerRegion(game, "model.region.southAtlantic", Region.RegionType.OCEAN, atlantic);
        for (ServerRegion region : new ServerRegion[]{northPacific, southPacific, atlantic, northAtlantic, southAtlantic}) {
            region.setPrediscovered(true);
            map.setRegion(region);
        }
        map.setRegion(pacific);
        pacific.setDiscoverable(true);
        pacific.setScoreValue(100);
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                Tile tile;
                if (!map.isValid(x, y) || (tile = map.getTile(x, y)).isLand()) continue;
                if (this.isNorth(map.getHeight(), y)) {
                    if (this.isWest(map.getWidth(), x)) {
                        northPacific.addTile(tile);
                        continue;
                    }
                    northAtlantic.addTile(tile);
                    continue;
                }
                if (this.isWest(map.getWidth(), x)) {
                    southPacific.addTile(tile);
                    continue;
                }
                southAtlantic.addTile(tile);
            }
        }
    }

    private void createLandRegions(Map map) {
        int c;
        Game game = map.getGame();
        ServerRegion arctic = new ServerRegion(game, "model.region.arctic", Region.RegionType.LAND);
        ServerRegion antarctic = new ServerRegion(game, "model.region.antarctic", Region.RegionType.LAND);
        map.setRegion(arctic);
        arctic.setPrediscovered(true);
        map.setRegion(antarctic);
        antarctic.setPrediscovered(true);
        int arcticHeight = 2;
        int antarcticHeight = map.getHeight() - 2 - 1;
        for (int x = 0; x < map.getWidth(); ++x) {
            Tile tile;
            int y;
            for (y = 0; y < arcticHeight; ++y) {
                if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                arctic.addTile(tile);
            }
            for (y = antarcticHeight; y < map.getHeight(); ++y) {
                if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                antarctic.addTile(tile);
            }
        }
        int thirdWidth = map.getWidth() / 3;
        int twoThirdWidth = 2 * thirdWidth;
        int thirdHeight = map.getHeight() / 3;
        int twoThirdHeight = 2 * thirdHeight;
        ServerRegion northWest = new ServerRegion(game, "model.region.northWest", Region.RegionType.LAND);
        northWest.setBounds(new Rectangle(0, 0, thirdWidth, thirdHeight));
        ServerRegion north = new ServerRegion(game, "model.region.north", Region.RegionType.LAND);
        north.setBounds(new Rectangle(thirdWidth, 0, thirdWidth, thirdHeight));
        ServerRegion northEast = new ServerRegion(game, "model.region.northEast", Region.RegionType.LAND);
        northEast.setBounds(new Rectangle(twoThirdWidth, 0, map.getWidth() - twoThirdWidth, thirdHeight));
        ServerRegion west = new ServerRegion(game, "model.region.west", Region.RegionType.LAND);
        west.setBounds(new Rectangle(0, thirdHeight, thirdWidth, thirdHeight));
        ServerRegion center = new ServerRegion(game, "model.region.center", Region.RegionType.LAND);
        center.setBounds(new Rectangle(thirdWidth, thirdHeight, thirdWidth, thirdHeight));
        ServerRegion east = new ServerRegion(game, "model.region.east", Region.RegionType.LAND);
        east.setBounds(new Rectangle(twoThirdWidth, thirdHeight, map.getWidth() - twoThirdWidth, thirdHeight));
        ServerRegion southWest = new ServerRegion(game, "model.region.southWest", Region.RegionType.LAND);
        southWest.setBounds(new Rectangle(0, twoThirdHeight, thirdWidth, map.getHeight() - twoThirdHeight));
        ServerRegion south = new ServerRegion(game, "model.region.south", Region.RegionType.LAND);
        south.setBounds(new Rectangle(thirdWidth, twoThirdHeight, thirdWidth, map.getHeight() - twoThirdHeight));
        ServerRegion southEast = new ServerRegion(game, "model.region.southEast", Region.RegionType.LAND);
        southEast.setBounds(new Rectangle(twoThirdWidth, twoThirdHeight, map.getWidth() - twoThirdWidth, map.getHeight() - twoThirdHeight));
        for (ServerRegion region : new ServerRegion[]{northWest, north, northEast, west, center, east, southWest, south, southEast}) {
            region.setDiscoverable(false);
            map.setRegion(region);
        }
        int continents = 0;
        boolean[][] landmap = new boolean[map.getWidth()][map.getHeight()];
        int[][] continentmap = new int[map.getWidth()][map.getHeight()];
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                continentmap[x][y] = 0;
                if (!map.isValid(x, y)) continue;
                Tile tile = map.getTile(x, y);
                boolean isMountainRange = false;
                if (tile.getRegion() != null) {
                    boolean bl = isMountainRange = tile.getRegion().getType() == Region.RegionType.MOUNTAIN;
                }
                if (tile.isLand()) {
                    if (y < arcticHeight || y >= antarcticHeight || isMountainRange) {
                        landmap[x][y] = false;
                        continue;
                    }
                    landmap[x][y] = true;
                    continue;
                }
                landmap[x][y] = false;
            }
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                if (!landmap[x][y]) continue;
                ++continents;
                boolean[][] continent = this.floodFill(landmap, new Map.Position(x, y));
                for (int yy = 0; yy < map.getHeight(); ++yy) {
                    for (int xx = 0; xx < map.getWidth(); ++xx) {
                        if (!continent[xx][yy]) continue;
                        continentmap[xx][yy] = continents;
                        landmap[xx][yy] = false;
                    }
                }
            }
        }
        logger.info("Number of individual landmasses is " + continents);
        int[] continentsize = new int[continents + 1];
        int landsize = 0;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                int n = continentmap[x][y];
                continentsize[n] = continentsize[n] + 1;
                if (continentmap[x][y] <= 0) continue;
                ++landsize;
            }
        }
        int oldcontinents = continents;
        for (int c2 = 1; c2 <= oldcontinents; ++c2) {
            if (continentsize[c2] <= 75) continue;
            boolean[][] splitcontinent = new boolean[map.getWidth()][map.getHeight()];
            Map.Position splitposition = new Map.Position(0, 0);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = 0; y < map.getHeight(); ++y) {
                    if (continentmap[x][y] == c2) {
                        splitcontinent[x][y] = true;
                        splitposition = new Map.Position(x, y);
                        continue;
                    }
                    splitcontinent[x][y] = false;
                }
            }
            while (continentsize[c2] > 75) {
                int targetsize = 75;
                if (continentsize[c2] < 150) {
                    targetsize = continentsize[c2] / 2;
                }
                ++continents;
                boolean[][] newregion = this.floodFill(splitcontinent, splitposition, targetsize);
                for (int x = 0; x < map.getWidth(); ++x) {
                    for (int y = 0; y < map.getHeight(); ++y) {
                        if (newregion[x][y]) {
                            continentmap[x][y] = continents;
                            splitcontinent[x][y] = false;
                            int n = c2;
                            continentsize[n] = continentsize[n] - 1;
                        }
                        if (!splitcontinent[x][y]) continue;
                        splitposition = new Map.Position(x, y);
                    }
                }
            }
        }
        logger.info("Number of land regions being created: " + continents);
        ServerRegion[] landregions = new ServerRegion[continents + 1];
        for (c = 1; c <= continents; ++c) {
            landregions[c] = new ServerRegion(map.getGame(), "model.region.land" + c, Region.RegionType.LAND);
            landregions[c].setDiscoverable(true);
            map.setRegion(landregions[c]);
        }
        continentsize = new int[continents + 1];
        landsize = 0;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                int n = continentmap[x][y];
                continentsize[n] = continentsize[n] + 1;
                if (continentmap[x][y] <= 0) continue;
                ++landsize;
                Tile tile = map.getTile(x, y);
                if (!tile.isLand() || tile.getRegion() != null) continue;
                landregions[continentmap[x][y]].addTile(tile);
            }
        }
        for (c = 1; c <= continents; ++c) {
            int score = Math.max((int)((float)continentsize[c] / (float)landsize * 1000.0f), 5);
            landregions[c].setScoreValue(score);
            logger.info("Created land region (size " + continentsize[c] + ", score value " + score + ").");
        }
    }

    private void createHighSeas(Map map) {
        TerrainGenerator.createHighSeas(map, this.getMapGeneratorOptions().getDistLandHighSea(), this.getMapGeneratorOptions().getMaxDistToEdge());
    }

    public static void determineHighSeas(Map map, int distToLandFromHighSeas, int maxDistanceToEdge) {
        TileType ocean = null;
        TileType highSeas = null;
        for (TileType tileType : FreeCol.getSpecification().getTileTypeList()) {
            if (!tileType.isWater()) continue;
            if (tileType.hasAbility("model.ability.moveToEurope")) {
                if (highSeas != null) continue;
                highSeas = tileType;
                if (ocean == null) continue;
                break;
            }
            if (ocean != null) continue;
            ocean = tileType;
            if (highSeas == null) continue;
            break;
        }
        if (highSeas == null || ocean == null) {
            throw new RuntimeException("Both Ocean and HighSeas TileTypes must be defined");
        }
        for (Tile tile : map.getAllTiles()) {
            tile.setRegion(null);
            if (tile.getType() != highSeas) continue;
            tile.setType(ocean);
        }
        TerrainGenerator.createHighSeas(map, distToLandFromHighSeas, maxDistanceToEdge);
    }

    private static void createHighSeas(Map map, int distToLandFromHighSeas, int maxDistanceToEdge) {
        if (distToLandFromHighSeas < 0 || maxDistanceToEdge < 0) {
            throw new IllegalArgumentException("The integer arguments cannot be negative.");
        }
        TileType highSeas = null;
        for (TileType t : FreeCol.getSpecification().getTileTypeList()) {
            if (!t.isWater() || !t.hasAbility("model.ability.moveToEurope")) continue;
            highSeas = t;
            break;
        }
        if (highSeas == null) {
            throw new RuntimeException("HighSeas TileType is defined by the 'sail-to-europe' attribute");
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            int x;
            for (x = 0; x < maxDistanceToEdge && x < map.getWidth() && !map.isLandWithinDistance(x, y, distToLandFromHighSeas); ++x) {
                if (!map.isValid(x, y)) continue;
                map.getTile(x, y).setType(highSeas);
            }
            for (x = 1; x <= maxDistanceToEdge && x <= map.getWidth() - 1 && !map.isLandWithinDistance(map.getWidth() - x, y, distToLandFromHighSeas); ++x) {
                if (!map.isValid(map.getWidth() - x, y)) continue;
                map.getTile(map.getWidth() - x, y).setType(highSeas);
            }
        }
    }

    private void createMountains(Map map) {
        Map.CircleIterator it;
        Map.Position p;
        int tries;
        float randomHillsRatio = 0.5f;
        int maximumLength = Math.max(this.getMapGeneratorOptions().getWidth(), this.getMapGeneratorOptions().getHeight()) / 10;
        int number = (int)((float)this.getMapGeneratorOptions().getNumberOfMountainTiles() * (1.0f - randomHillsRatio));
        logger.info("Number of land tiles is " + this.getMapGeneratorOptions().getLand() + ", number of mountain tiles is " + number);
        logger.fine("Maximum length of mountain ranges is " + maximumLength);
        TileType hills = FreeCol.getSpecification().getTileType("model.tile.hills");
        TileType mountains = FreeCol.getSpecification().getTileType("model.tile.mountains");
        if (hills == null || mountains == null) {
            throw new RuntimeException("Both Hills and Mountains TileTypes must be defined");
        }
        int counter = 0;
        block0: for (tries = 0; tries < 100; ++tries) {
            if (counter >= number) continue;
            p = map.getRandomLandPosition();
            if (p == null) {
                return;
            }
            Tile startTile = map.getTile(p);
            if (startTile.getType() == hills || startTile.getType() == mountains) continue;
            it = map.getCircleIterator(p, true, 3);
            while (it.hasNext()) {
                if (map.getTile((Map.Position)it.next()).getType() != mountains) continue;
                continue block0;
            }
            it = map.getCircleIterator(p, true, 2);
            while (it.hasNext()) {
                if (map.getTile((Map.Position)it.next()).isLand()) continue;
                continue block0;
            }
            ServerRegion mountainRegion = new ServerRegion(map.getGame(), "model.region.mountain" + tries, Region.RegionType.MOUNTAIN, startTile.getRegion());
            mountainRegion.setDiscoverable(true);
            mountainRegion.setClaimable(true);
            map.setRegion(mountainRegion);
            Map.Direction direction = map.getRandomDirection();
            int length = maximumLength - this.random.nextInt(maximumLength / 2);
            for (int index = 0; index < length; ++index) {
                Tile nextTile = map.getTile(p = Map.getAdjacent(p, direction));
                if (nextTile == null || !nextTile.isLand()) continue;
                nextTile.setType(mountains);
                mountainRegion.addTile(nextTile);
                ++counter;
                it = map.getCircleIterator(p, false, 1);
                while (it.hasNext()) {
                    Tile neighborTile = map.getTile((Map.Position)it.next());
                    if (neighborTile == null || !neighborTile.isLand() || neighborTile.getType() == mountains) continue;
                    int r = this.random.nextInt(8);
                    if (r == 0) {
                        neighborTile.setType(mountains);
                        mountainRegion.addTile(neighborTile);
                        ++counter;
                        continue;
                    }
                    if (r <= 2) continue;
                    neighborTile.setType(hills);
                    mountainRegion.addTile(neighborTile);
                }
            }
            int scoreValue = 2 * mountainRegion.getSize();
            mountainRegion.setScoreValue(scoreValue);
            logger.info("Created mountain region (direction " + (Object)((Object)direction) + ", length " + length + ", size " + mountainRegion.getSize() + ", score value " + scoreValue + ").");
        }
        logger.info("Added " + counter + " mountain range tiles.");
        number = (int)((float)this.getMapGeneratorOptions().getNumberOfMountainTiles() * randomHillsRatio);
        counter = 0;
        block5: for (tries = 0; tries < 1000; ++tries) {
            Tile t;
            if (counter >= number || (t = map.getTile(p = map.getRandomLandPosition())).getType() == hills || t.getType() == mountains) continue;
            it = map.getCircleIterator(p, true, 3);
            while (it.hasNext()) {
                if (map.getTile((Map.Position)it.next()).getType() != mountains) continue;
                continue block5;
            }
            it = map.getCircleIterator(p, true, 1);
            while (it.hasNext()) {
                if (map.getTile((Map.Position)it.next()).isLand()) continue;
                continue block5;
            }
            int k = this.random.nextInt(4);
            if (k == 0) {
                t.setType(mountains);
            } else {
                t.setType(hills);
            }
            ++counter;
        }
        logger.info("Added " + counter + " random hills tiles.");
    }

    private void createRivers(Map map) {
        int number = this.getMapGeneratorOptions().getNumberOfRivers();
        int counter = 0;
        HashMap<Map.Position, River> riverMap = new HashMap<Map.Position, River>();
        ArrayList<River> rivers = new ArrayList<River>();
        block0: for (int i = 0; i < number; ++i) {
            block1: for (int tries = 0; tries < 100; ++tries) {
                Map.Position position = map.getRandomLandPosition();
                if (!map.getTile(position).getType().canHaveRiver()) continue;
                Map.CircleIterator it = map.getCircleIterator(position, true, 2);
                while (it.hasNext()) {
                    Tile neighborTile = map.getTile((Map.Position)it.next());
                    if (neighborTile.isLand()) continue;
                    continue block1;
                }
                if (riverMap.get(position) != null) continue;
                ServerRegion riverRegion = new ServerRegion(map.getGame(), "model.region.river" + i, Region.RegionType.RIVER, map.getTile(position).getRegion());
                riverRegion.setDiscoverable(true);
                riverRegion.setClaimable(true);
                River river = new River(map, riverMap, riverRegion);
                if (river.flowFromSource(position)) {
                    logger.fine("Created new river with length " + river.getLength());
                    map.setRegion(riverRegion);
                    rivers.add(river);
                    ++counter;
                    continue block0;
                }
                logger.fine("Failed to generate river.");
            }
        }
        logger.info("Created " + counter + " rivers of maximum " + number + ".");
        for (River river : rivers) {
            ServerRegion region = river.getRegion();
            int scoreValue = 0;
            for (RiverSection section : river.getSections()) {
                scoreValue += section.getSize();
            }
            region.setScoreValue(scoreValue *= 2);
            logger.info("Created river region (length " + river.getLength() + ", score value " + scoreValue + ").");
        }
    }

    private void findLakes(Map map) {
        Game game = map.getGame();
        ServerRegion inlandlakes = new ServerRegion(game, "model.region.inlandlakes", Region.RegionType.LAKE);
        map.setRegion(inlandlakes);
        inlandlakes.setPrediscovered(true);
        Map.Position p = null;
        block0: for (int x : new int[]{0, map.getWidth() - 1}) {
            for (int y = 0; y < map.getHeight(); ++y) {
                Tile tile = map.getTile(x, y);
                if (tile == null || tile.getType() == null || tile.isLand()) continue;
                p = new Map.Position(x, y);
                continue block0;
            }
        }
        if (p == null) {
            logger.warning("Find lakes: unable to find entry point.");
            return;
        }
        boolean[][] watermap = new boolean[map.getWidth()][map.getHeight()];
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                watermap[x][y] = !map.getTile(x, y).isLand();
            }
        }
        boolean[][] visited = this.floodFill(watermap, p);
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                Tile tile;
                if (!watermap[x][y] || visited[x][y] || (tile = map.getTile(x, y)) == null) continue;
                tile.setType(this.lake);
                inlandlakes.addTile(tile);
            }
        }
    }

    private boolean isNorth(int height, int y) {
        return y < height / 2;
    }

    private boolean isWest(int width, int x) {
        return x < width / 2;
    }

    private boolean[][] floodFill(boolean[][] boolmap, Map.Position p, int limit) {
        LinkedList<Map.Position> q = new LinkedList<Map.Position>();
        boolean[][] visited = new boolean[boolmap.length][boolmap[0].length];
        visited[p.getX()][p.getY()] = true;
        --limit;
        do {
            for (Map.Direction direction : Map.Direction.values()) {
                Map.Position n = Map.getAdjacent(p, direction);
                if (!Map.isValid(n, boolmap.length, boolmap[0].length) || !boolmap[n.getX()][n.getY()] || visited[n.getX()][n.getY()] || limit <= 0) continue;
                visited[n.getX()][n.getY()] = true;
                --limit;
                q.add(n);
            }
        } while ((p = (Map.Position)q.poll()) != null && limit > 0);
        return visited;
    }

    private boolean[][] floodFill(boolean[][] boolmap, Map.Position p) {
        return this.floodFill(boolmap, p, Integer.MAX_VALUE);
    }
}

