/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.net.Socket;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.server.model.ServerModelObject;

public class ServerPlayer
extends Player
implements ServerModelObject {
    private Socket socket;
    private Connection connection;
    private boolean connected = false;
    private int remainingEmigrants = 0;
    private String serverID;

    public ServerPlayer(Game game, String name, boolean admin, Socket socket, Connection connection) {
        super(game, name, admin);
        this.socket = socket;
        this.connection = connection;
        this.resetExploredTiles(this.getGame().getMap());
        this.resetCanSeeTiles();
        this.connected = connection != null;
    }

    public ServerPlayer(Game game, String name, boolean admin, boolean ai, Socket socket, Connection connection, Nation nation) {
        super(game, name, admin, ai, nation);
        this.socket = socket;
        this.connection = connection;
        this.resetExploredTiles(this.getGame().getMap());
        this.resetCanSeeTiles();
        this.connected = connection != null;
    }

    public ServerPlayer(XMLStreamReader in) throws XMLStreamException {
        this.readFromServerAdditionElement(in);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public int getRemainingEmigrants() {
        return this.remainingEmigrants;
    }

    public void setRemainingEmigrants(int emigrants) {
        this.remainingEmigrants = emigrants;
    }

    public void resetExploredTiles(Map map) {
        if (map != null) {
            Iterator<Unit> unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                this.setExplored(unit.getTile());
                Map.CircleIterator positionIterator = unit.getColony() != null ? map.getCircleIterator(unit.getTile().getPosition(), true, 2) : map.getCircleIterator(unit.getTile().getPosition(), true, unit.getLineOfSight());
                while (positionIterator.hasNext()) {
                    Map.Position p = (Map.Position)positionIterator.next();
                    this.setExplored(map.getTile(p));
                }
            }
        }
    }

    public boolean hasExplored(Tile tile) {
        return tile.isExploredBy(this);
    }

    public void setExplored(Tile tile) {
        tile.setExploredBy(this, true);
    }

    public void setExplored(Unit unit) {
        if (this.getGame() == null || this.getGame().getMap() == null || unit == null || unit.getLocation() == null || unit.getTile() == null) {
            return;
        }
        if (this.canSeeTiles == null) {
            this.resetCanSeeTiles();
        }
        this.setExplored(unit.getTile());
        this.canSeeTiles[unit.getTile().getPosition().getX()][unit.getTile().getPosition().getY()] = true;
        Map.CircleIterator positionIterator = this.getGame().getMap().getCircleIterator(unit.getTile().getPosition(), true, unit.getLineOfSight());
        while (positionIterator.hasNext()) {
            Map.Position p = (Map.Position)positionIterator.next();
            if (p == null) continue;
            this.setExplored(this.getGame().getMap().getTile(p));
            if (this.canSeeTiles != null) {
                this.canSeeTiles[p.getX()][p.getY()] = true;
                continue;
            }
            this.invalidateCanSeeTiles();
        }
    }

    public void revealMap() {
        Map.WholeMapIterator positionIterator = this.getGame().getMap().getWholeMapIterator();
        while (positionIterator.hasNext()) {
            Map.Position p = (Map.Position)positionIterator.next();
            this.setExplored(this.getGame().getMap().getTile(p));
        }
        ((BooleanOption)this.getGame().getGameOptions().getObject("model.option.unitHiding")).setValue(false);
        ((BooleanOption)this.getGame().getGameOptions().getObject("model.option.fogOfWar")).setValue(false);
        this.resetCanSeeTiles();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.connected = connection != null;
    }

    public void toServerAdditionElement(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ServerPlayer.getServerAdditionXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    public void updateID() {
        this.setId(this.serverID);
    }

    public void readFromServerAdditionElement(XMLStreamReader in) throws XMLStreamException {
        this.serverID = in.getAttributeValue(null, "ID");
        in.nextTag();
    }

    public static String getServerAdditionXMLElementTagName() {
        return "serverPlayer";
    }

    public String toString() {
        return "ServerPlayer[name=" + this.getName() + ",serverID=" + this.serverID + ",conn=" + this.connection + "]";
    }
}

