/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Server
extends Thread {
    private static Logger logger = Logger.getLogger(Server.class.getName());
    private ServerSocket serverSocket;
    private HashMap<Socket, Connection> connections = new HashMap();
    private boolean running = true;
    private FreeColServer freeColServer;
    private int port;
    private final Object shutdownLock = new Object();

    public Server(FreeColServer freeColServer, int port) throws IOException {
        super("FreeColServer:Server");
        this.freeColServer = freeColServer;
        this.port = port;
        this.serverSocket = new ServerSocket(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = this.shutdownLock;
        synchronized (object) {
            while (this.running) {
                Socket clientSocket = null;
                try {
                    clientSocket = this.serverSocket.accept();
                    logger.info("Got client connection from " + clientSocket.getInetAddress().toString());
                    new Connection(clientSocket, this.freeColServer.getUserConnectionHandler(), "FreeColServer:");
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    logger.warning(sw.toString());
                }
            }
            return;
        }
    }

    public void sendToAll(Element element, Connection exceptConnection) {
        for (Connection connection : this.connections.values()) {
            if (connection == exceptConnection) continue;
            try {
                connection.sendAndWait(element);
            }
            catch (IOException e) {
                logger.warning("Exception while attempting to send to " + connection);
            }
        }
    }

    public void sendToAll(Element element) {
        this.sendToAll(element, null);
    }

    public int getPort() {
        return this.port;
    }

    public void setMessageHandlerToAllConnections(MessageHandler messageHandler) {
        for (Connection connection : this.connections.values()) {
            connection.setMessageHandler(messageHandler);
        }
    }

    public Iterator<Connection> getConnectionIterator() {
        return this.connections.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.warning("Could not close the server socket!");
        }
        Object e = this.shutdownLock;
        synchronized (e) {
        }
        for (Connection c : this.connections.values()) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException e2) {
                logger.warning("Could not close the connection.");
            }
        }
        this.freeColServer.removeFromMetaServer();
        logger.info("Server shutdown.");
    }

    public Connection getConnection(Socket socket) {
        return this.connections.get(socket);
    }

    public void addDummyConnection(Connection connection) {
        this.connections.put(new Socket(), connection);
    }

    public void addConnection(Connection connection) {
        this.connections.put(connection.getSocket(), connection);
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection.getSocket());
    }
}

