/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class MergeTranslations {
    public static void main(String[] args) throws Exception {
        File targetDirectory;
        File sourceDirectory = new File(args[0]);
        if (!sourceDirectory.isDirectory()) {
            System.exit(1);
        }
        if (!(targetDirectory = new File(args[1])).isDirectory()) {
            System.exit(1);
        }
        final String localeKey = args.length > 2 ? args[2] : "";
        String[] sourceFiles = sourceDirectory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + localeKey + ".*\\.properties");
            }
        });
        String[] targetFiles = targetDirectory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + localeKey + ".*\\.properties");
            }
        });
        for (String name : sourceFiles) {
            int c;
            System.out.println("Processing source file: " + name);
            File sourceFile = new File(sourceDirectory, name);
            Properties sourceProperties = new Properties();
            sourceProperties.load(new FileInputStream(sourceFile));
            File targetFile = new File(targetDirectory, name);
            if (targetFile.exists()) {
                Properties targetProperties = new Properties();
                targetProperties.load(new FileInputStream(targetFile));
                ArrayList<Map.Entry<Object, Object>> missingProperties = new ArrayList<Map.Entry<Object, Object>>();
                for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
                    if (targetProperties.containsKey(entry.getKey())) continue;
                    missingProperties.add(entry);
                }
                if (missingProperties.isEmpty()) continue;
                FileWriter out = new FileWriter(targetFile, true);
                out.write("### Merged from trunk on " + DateFormat.getDateTimeInstance().format(new Date()) + " ###\n");
                for (Map.Entry entry : missingProperties) {
                    out.write((String)entry.getKey());
                    out.write("=");
                    out.write((String)entry.getValue());
                    out.write("\n");
                }
                out.close();
                continue;
            }
            System.out.println("Copying " + name + " from trunk.");
            FileReader in = new FileReader(sourceFile);
            FileWriter out = new FileWriter(targetFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
    }
}

