
#include "betlocation.h"

#include <qobject.h>

#include <iostream>
using namespace std;

Bet BetLocation::betOn( int bet, int number, TableState ts ){
	// at this top level, just see if the number is a valid bet
	// if it is, pass it on the the subclass

	if( isValidNumber( number ) ){
		if( bet>0 ) return ibetOn( bet, number, ts );
		else{
			Bet b=getBetFor( number );
			int negbet=bet;

			// check to make sure we're not removing more than we've bet
			// if so, remove the whole bet
			if( bet+b.bet<0 ) negbet=-b.bet;
			
			Bet nb=ibetOn( negbet, number, ts ); 
			if( negbet!=0 && nb.result==NoBet ){
				nb.result=TakenDown;
				nb.bet=negbet;
			}
			return nb;
		}
	}
	return Bet( InvalidNumber );
}

void BetLocation::setOffAndOn( bool b ){ oao=b; }

/******************************************/
/************** TOP ROW BETS **************/
/******************************************/

TopRow::TopRow( int max6, int max5, int max4 ){ 
	// set the maximum odds for each available number
	for( int i=0; i<11; i++ )	mbets[i]=modds[i]=0; 
	setOdds( max6, max5, max4 );
}

Bet TopRow::ibetOn( int bet, int number, TableState ts ){
	// we can only place bets when the tablestate is Normal
	if( Normal==ts ){
		mbets[number]+=bet;
		return getBetFor( number );
	}
	return Bet( WrongTableState );
}

Bet TopRow::oddsOn( int bet, int number, TableState ts ){
	// we can't put an odds bet on a number that 
	// exceeds the maxbet for that number, or when there is no number
	if( !isValidNumber( number ) ) return Bet( InvalidNumber );
	
	if( Normal==ts ){
		int totodds=bet+modds[number];
		if( totodds>=0 && totodds<=( mbets[number]*MAXODDS[number] ) ){
			modds[number]+=bet;	
			return getBetFor( number );
		}
		else return Bet( TooManyOdds );
	}
	else return Bet( WrongTableState );
}

void TopRow::clearbets(){	
	for( int i=0; i<11; i++ ){
		if( mbets[i]>0 ){
			const Bet b=getBetFor( i );
			mbets[i]=modds[i]=0; 
			emit removedBet( b );
		}
	}
}

bool TopRow::isValidNumber( int num ) const { return isValid( num ); }
bool TopRow::isValid( int num ){
	switch( num ){
	case 4:
	case 5:
	case 6:
	case 8:
	case 9:
	case 10:
		return true;
	default:
		return false;
	}
}

vector<Bet> TopRow::bets() const {
	vector<Bet> ret;
	for( int i=0; i<11; i++ ){
		Bet b=getBetFor( i );
		if( b.ok() ) ret.push_back( b );
	}
	return ret;
}


Bet TopRow::getBetFor( int number ) const {
	return Bet( number, mbets[number], BETTYPE, modds[number] );
}

void TopRow::setOdds( int max6, int max5, int max4 ){
	MAXODDS[4]=MAXODDS[10]=max4;
	MAXODDS[5]=MAXODDS[9]=max5;
	MAXODDS[6]=MAXODDS[8]=max6;
}

#include "betlocation.moc"
