
#ifndef BETLOCATION
#define BETLOCATION

#include <qobject.h>

#include "constants.h"
#include "bet.h"

#include <vector>
using namespace std;

class QString;

/** an abstract bet taking class **/
class BetLocation : public QObject {
	Q_OBJECT
		public:
	virtual void clearbets() =0;
	virtual int handleRoll( int die1, int die2, TableState ts, QString& msg ) =0;
	virtual vector<Bet> bets() const =0;

	Bet betOn( int bet, int number, TableState ts );
	virtual Bet getBetFor( int number ) const =0;
	void setOffAndOn( bool );

 protected:
	virtual bool isValidNumber( int ) const =0;
	virtual Bet ibetOn( int bet, int number, TableState ts ) =0;

	bool oao;

 signals:
	void removedBet( const Bet& );
};

/** A bet taker for the top row of numbers **/
class TopRow : public BetLocation {
 public:
	static bool isValid( int number );

	TopRow( int max6, int max5, int max4 ); // allows for 3x4x5x odds
	
	void setOdds( int max6, int max5, int max4 ); // allows for 3x4x5x odds
	void clearbets();
	vector<Bet> bets() const;

	virtual Bet getBetFor( int number ) const;

	virtual Bet ibetOn( int bet, int number, TableState ts );
	virtual Bet oddsOn( int bet, int number, TableState ts );

 protected:
	// bet amounts will be a (sparse) array based on the bet number
	int mbets[11];
	int modds[11];
	int MAXODDS[11];
	int BETTYPE;

	bool isValidNumber( int number ) const;
};

#endif

