
#include "buttonbar.h"

#include <qobject.h>

#include <iostream>
using namespace std;

/*******************************************/
/************** COME ROW BETS **************/
/*******************************************/
ComeRow::ComeRow( int max6, int max5, int max4 ) : TopRow( max6, max5, max4 ){ 
	BETTYPE=Bet::NUMBER;
}

int ComeRow::handleRoll( int die1, int die2, TableState ts, QString& msg ){
	const int NUM=die1+die2;
	int win=0;

	bool valid=isValid( NUM );

	if( ClearingMark==ts ){
		// we win money when we're clearing a mark and haven't rolled a 7
		if( 7==NUM ) clearbets();
		else{
			if( valid ){
				win=betwin( NUM, msg );
				win+=mbets[NUM]+modds[NUM];
				if( mbets[NUM] ){
					Bet bet=getBetFor( NUM );
					mbets[NUM]=modds[NUM]=0;
					emit removedBet( bet );
				}
			}
		}
	}
	else if( NoMark==ts && 7==NUM ){
		// we have bets on the table, but a 7 was rolled
		// so lose the bets and return the odds
		for( int i=0; i<11; i++ ){
			win+=modds[i]; // return the odds
			clearbets();  // clear all the bets
		}
		if( win ) msg=QObject::tr( "Odds are returned with no number is established and a 7 is rolled" );
	}
	else if( PlacingMark==ts ){
		// we have a bet on a number that is getting the button
		// pay even money on the bet and return the odds
		if( valid ){
			win=mbets[NUM]*2+modds[NUM];
			if( mbets[NUM]>0 ){
				const Bet b=getBetFor( NUM );
				mbets[NUM]=modds[NUM]=0;
				emit removedBet( b );
			}
		}
		if( win ) msg=QObject::tr( "Bets pay even money and odds are returned when a number is established on a previous come bet." );
	}
	else if( Normal==ts ){
		if( valid ){
			win=betwin( NUM, msg );
			win+=mbets[NUM]+modds[NUM];
			if( mbets[NUM]>0 ){
				const Bet b=getBetFor( NUM );
				mbets[NUM]=modds[NUM]=0;
				emit removedBet( b );
			}
		}
	}

	return win;
}

int ComeRow::betwin( int num, QString& msg ){
	// only calculate the winnings, not the original bet or odds
	if( mbets[num] ){
		// bets pay even money, and the bet is returned along with the odds		
		int win=mbets[num];
		QString st;

		switch( num ){
		case 4:
		case 10:
			st="2:1";
			win+=modds[num]*2;
			break;
		case 5:
		case 9:
			st="3:2";
			win+=modds[num]*3/2;
			break;
		case 6:
		case 8:
			st="6:5";
			win+=modds[num]*6/5;
			break;
		}
		msg=QObject::tr( "Top Row winners pay even money plus %1 odds on %2" ).arg( st ).arg( num );
		return win;
	}
	return 0;
}


/********************************************/
/************** PLACE ROW BETS **************/
/********************************************/
PlaceRow::PlaceRow() : ComeRow( 0, 0, 0 ){ BETTYPE=Bet::PLACE; }

void PlaceRow::buyPlaces( bool b ){ dobuys=b; }

int PlaceRow::betwin( int num, QString& msg ){
	// only calculate the winnings, not the original bet or odds
	if( mbets[num] ){
		bool andbuy=false;
		int win=0;
		QString st;

		switch( num ){
		case 4:
		case 10:
			if( dobuys && mbets[num]>=20 ){
				st="2:1";
				win=mbets[num]*2;
				andbuy=true;
			}
			else{
				st="9:5";
				win=mbets[num]*9/5;
			}
			break;
		case 5:
		case 9:
			if( dobuys && mbets[num]>=20 ){
				st="3:2";
				win=mbets[num]*3/2;
				andbuy=true;
			}
			else{
				st="7:5";
				win=mbets[num]*7/5;
			}
			break;
		case 6:
		case 8:
			if( dobuys && mbets[num]>=20 ){
				st="6:5";
				win=mbets[num]*6/5;
				andbuy=true;
			}
			else{
				st="7:6";
				win=mbets[num]*7/6;
			}
			break;
		}
		if( andbuy ){
			win-=( int )( mbets[num]*0.05 );
			msg=QObject::tr( "Buy bet winners on %1 pay %2 odds minus a 5% commission on the bet" ).arg( num ).arg( st );
		}
		else msg=QObject::tr( "Place bet winners on %1 pay %2 odds" ).arg( num ).arg( st );
		return win;
	}
	return 0;
}

Bet PlaceRow::getBetFor( int number ) const {
	Bet myb=ComeRow::getBetFor( number );
	if( myb.bet>=20 ) myb.buy=true;
	return myb;
}

Bet PlaceRow::ibetOn( int bet, int number, TableState ts ){
	Bet b=ComeRow::ibetOn( bet, number, ts );
	b.buy=( dobuys && b.bet>=20 );
	return b;
}

/************************************************/
/************** DONT COME ROW BETS **************/
/************************************************/
DontComeRow::DontComeRow( int m6, int m5, int m4 ) : TopRow( m6, m5, m4 ){ 
	BETTYPE=Bet::NONUMBER;
}

int DontComeRow::handleRoll( int die1, int die2, TableState ts, QString& msg ){
	const int NUM=die1+die2;
	int win=0;

	bool valid=isValid( NUM );

	if( ClearingMark==ts ){
		// we win money when we're clearing a mark and just rolled a 7
		if( 7==NUM ){
			for( int i=0; i<11; i++ ){
				QString tstr;
				win+=betwin( i, tstr );
				win+=mbets[i]+modds[i];
				
				if( mbets[i]>0 ){
					const Bet bb=getBetFor( i );
					mbets[i]=modds[i]=0;
					emit removedBet( bb );
				}

				if( tstr ){
					if( msg.isEmpty() ) msg=tstr;
					else msg+="\n"+tstr;
				}
			}
		}
		// if we're clearing a mark, all the bets come down
		clearbets();
	}
	else if( Normal==ts ){
		// we have a winner in normal play, which is a loser in dontcome
		if( valid ){
			if( mbets[NUM]>0 ){
				const Bet bb=getBetFor( NUM );
				mbets[NUM]=modds[NUM]=0;
				emit removedBet( bb );
			}
		}
	}
	
	return win;
}

int DontComeRow::betwin( int num, QString& msg ){
	// only calculate the winnings, not the original bet or odds
	if( mbets[num] ){
		// bets pay even money plus some odds
		int win=mbets[num];
		QString st;

		switch( num ){
		case 4:
		case 10:
			st="1:2";
			win+=modds[num]/2;
			break;
		case 5:
		case 9:
			st="2:3";
			win+=modds[num]*2/3;
			break;
		case 6:
		case 8:
			st="5:6";
			win+=modds[num]*5/6;
			break;
		}
		msg=QObject::tr( "Don't Pass/Don't Come bets pay even money plus %1 odds on %2" ).arg( st ).arg( num );
		return win;
	}
	return 0;
}

/*************************************************/
/************** DONT PLACE ROW BETS **************/
/*************************************************/
DontPlaceRow::DontPlaceRow() : DontComeRow( 0, 0, 0 ){ BETTYPE=Bet::NOPLACE; }

void DontPlaceRow::buyPlaces( bool b ){ dobuys=b; }

int DontPlaceRow::betwin( int num, QString& msg ){
	// only calculate the winnings, not the original bet or odds
	if( mbets[num] ){
		int win=0;
		QString st;
		
		switch( num ){
		case 4:
		case 10:
			st="1:2";
			win=mbets[num]/2;
			break;
		case 5:
		case 9:
			st="2:3";
			win=mbets[num]*2/3;
			break;
		case 6:
		case 8:
			st="5:6";
			win=mbets[num]*5/6;
			break;
		}

		win-=( int )( mbets[num]*0.05 );
		msg=QObject::tr( "Lay winners pay %1 odds on %2 minus a 5% commission on the bet" ).arg( st ).arg( num );
		return win;
	}
	return 0;
}

Bet DontPlaceRow::getBetFor( int number ) const {
	Bet myb=DontComeRow::getBetFor( number );
	switch( myb.number ){
	case 4:
	case 10:
		myb.buy=( myb.bet>=40 );
		break;
	case 5:
	case 9:
		myb.buy=( myb.bet>=30 );
		break;
	case 6:
	case 8:
		myb.buy=( myb.bet>=24 );
		break;
	}
	return myb;
}

Bet DontPlaceRow::ibetOn( int bet, int number, TableState ts ){
	Bet b=DontComeRow::ibetOn( bet, number, ts );
	switch( b.number ){
	case 4:
	case 10:
		b.buy=( b.bet>=40 );
		break;
	case 5:
	case 9:
		b.buy=( b.bet>=30 );
		break;
	case 6:
	case 8:
		b.buy=( b.bet>=24 );
		break;
	}
	return b;
}

/***************************************/
/************** LINE BETS **************/
/***************************************/
LineBet::LineBet( int typer ){
	type=typer; 
	mbet=0;
}

void LineBet::clearbets(){
	if( mbet ){
		const Bet b=getBetFor( 0 );
		mbet=0; 
		emit removedBet( b );
	}
}

bool LineBet::isValidNumber( int num ) const {
	return TopRow::isValid( num );
}

int LineBet::handleRoll( int die1, int die2, TableState ts, QString& msg ){
	// this class will only hold a number for one roll, and then, if the
	// bet still exists, it will get moved to the made number
	//
	// I hope these are the states that the different bets can exist in:
	//
	// PASS:   NoMark (wins on 7, 11; loses on 2, 3, 12)
	//
	// NOPASS: NoMark (wins on 2, 3; loses on 7, 11) 
	//
	// COME:   Normal (wins on 11; loses on 2, 3, 12)
	//         ClearingMark (wins on 7)
	//
	// NOCOME: Normal (wins on 2, 3; loses on 11 )	
	//         ClearingMark (loses on 7)

	int win=0;
	const int NUM=die1+die2;

	bool craps=( 2==NUM || 3==NUM || 12==NUM );
	bool yo=( 11==NUM );
	bool seven=( 7==NUM );

	if( Bet::PASS==type ){
		if( NoMark==ts ){
			if( seven|| yo ){
				msg=QObject::tr( "Pass bets pay even money on %1 when no number is established" ).arg( NUM );
				win=mbet;
			}
			else if( craps ) clearbets();
		}
	}

	else if( Bet::NOPASS==type ){
		if( NoMark==ts ){
			if( 2==NUM || 3==NUM ){
				msg=QObject::tr( "Don't Pass bets pay even money on %1 when no number is established" ).arg( NUM );
				win=mbet;
			}
			else if( seven || yo ) clearbets();
		}
	}
	
	else if( Bet::NOCOME==type ){
		if( Normal==ts ){
			if( 2==NUM || 3==NUM ){
				msg=QObject::tr( "Don't Come bets pay even money on %1 during regular play" ).arg( NUM );
				win=mbet;
			}
			else if( yo ) clearbets();
		}
		else if( ClearingMark==ts ){
			if( seven ) clearbets();
		}
	}

	else if( Bet::COME==type ){
		if( Normal==ts ){
			if( seven|| yo ){
				msg=QObject::tr( "Come bets pay even money on %1" ).arg( NUM );
				win=mbet;
			}
			else if( craps ) clearbets();			
		}
		else if( ClearingMark==ts ){
			if( seven ){
				msg=QObject::tr( "Come bets pay even money on %1 and bet is returned when a number is cleared" ).arg( NUM );
				win=mbet*2;
				clearbets();
			}
		}
	}

	return win;
}

Bet LineBet::ibetOn( int b, int, TableState ts ){	return bet( b, ts ); }
Bet LineBet::bet( int newbet, TableState ts ){
	if( Normal==ts ){
		if( Bet::COME==type || Bet::NOCOME==type ){
			if( newbet<0 ){
				if( mbet ){ // we have a bet we're reducing
					if( newbet+mbet<0 ) newbet=0-mbet; // but not by too much
				}
				else newbet=0; // we don't have a bet, so don't do anything
			}
			mbet+=newbet;
		}
		else return Bet( WrongTableState );
	}
	else if( NoMark==ts ){
		if( Bet::PASS==type || Bet::NOPASS==type ){
			if( newbet<0 ){
				if( mbet ){ // we have a bet we're reducing
					if( newbet+mbet<0 ) newbet=0-mbet; // but not by too much
				}
				else newbet=0; // we don't have a bet, so don't do anything
			}
			mbet+=newbet;
		}
		else return Bet( WrongTableState );
	}

	Bet b=getBetFor( 0 );
	if( newbet!=0 && NoBet==b.result ){
		b.result=TakenDown;
		b.bet=newbet;
	}

	return b;
}

Bet LineBet::getBetFor( int ) const { return Bet( 0, mbet, type ); }
vector<Bet> LineBet::bets() const {
	vector<Bet> ret;
	Bet b=getBetFor( 0 );
	if( b.ok() ) ret.push_back( b );
	return ret;
}

int LineBet::val() const { return mbet; }

