
#ifndef BUTTONBAR
#define BUTTONBAR

#include "betlocation.h"

/******************/
/** Come bet row **/
/******************/
class ComeRow : public TopRow {
 public:
	ComeRow( int max6, int max5, int max4 ); // allows for 3x4x5x odds
	int handleRoll( int die1, int die2, TableState ts, QString& msg );	
	
 protected:
	virtual int betwin( int number, QString& msg );
};

/*******************/
/** Place bet row **/
/*******************/
class PlaceRow : public ComeRow {
 public:
	PlaceRow();

	virtual Bet ibetOn( int bet, int number, TableState ts );	
	void buyPlaces( bool );
	virtual Bet getBetFor( int number ) const;

 protected:
	bool dobuys;

	int betwin( int number, QString& msg );
};

/************************/
/** Don't Come bet row **/
/************************/
class DontComeRow : public TopRow {
 public:
	DontComeRow( int max6, int max5, int max4 ); // allows for 3x4x5x odds
	int handleRoll( int die1, int die2, TableState ts, QString& msg );	

 protected:
	virtual int betwin( int number, QString& msg );
};

/*************************/
/** Don't Place bet row **/
/*************************/
class DontPlaceRow : public DontComeRow {
 public:
	DontPlaceRow();

	virtual Bet ibetOn( int bet, int number, TableState ts );
	void buyPlaces( bool );
	virtual Bet getBetFor( int number ) const;

 protected:
	bool dobuys;

	int betwin( int number, QString& msg );
};


/********************************************************/
/** Pass and Come, Don't Pass and Don't Come Line bets **/
/********************************************************/
class LineBet : public BetLocation {
 public:
	LineBet( int bettype );
	void clearbets();
	int handleRoll( int die1, int die2, TableState ts, QString& msg );
	Bet bet( int bet, TableState ts );
	Bet getBetFor( int number ) const;
	Bet ibetOn( int bet, int number, TableState ts );
	vector<Bet> bets() const;
	int val() const;
	
 protected:
	int mbet, type;
	
	bool isValidNumber( int i ) const;
};

#endif
