
#include "diedisplay.h"

#include <qpainter.h>
#include <kglobal.h>
#include <kstandarddirs.h>

QPixmap * DieDisplay::dicepix=0;

DieDisplay::DieDisplay( QWidget * p, const char * n ) : QPushButton( p, n ){
	if( 0==dicepix ){
		dicepix=new QPixmap[7];
		for( int i=1; i<7; i++ ) dicepix[i]=QPixmap( locate("data", "kraps/die"+QString::number( i )+".png" ) );
	}

	display( rand()%6+1 ); // pick some random number
}

void DieDisplay::display( int i ){ setPixmap( dicepix[i] ); }

CashDisplay::CashDisplay( QWidget * p, const char * n ) : QLabel( p, n ){
	dicepix=QPixmap( locate("data", "kraps/bankchip.png" ) );
	setPixmap( dicepix );
	number=0;
}

void CashDisplay::recash( int i ){ 
	number=i;
	update();
}

void CashDisplay::drawContents( QPainter * p ){
	QLabel::drawContents( p );
	QFont fnt=font();
	fnt.setPointSize( fnt.pointSize()+5 );
	fnt.setBold( true );
	p->setFont( fnt );
	p->setPen( QPen( white ) );
	p->drawText( rect(), AlignCenter, QString( "$%1" ).arg( number ) );
}

#include "diedisplay.moc"
