
#include <iostream>

#include "fieldrow.h"
#include <qobject.h>

FieldRow::FieldRow( bool trip12 ){ 
	tripleOnTwelve=trip12; 
	mbet=0;
}

void FieldRow::clearbets(){ 
	if( mbet ){
		const Bet bb=getBetFor( 0 );
		mbet=0; 
		emit removedBet( bb );
	}
}

bool FieldRow::isValidNumber( int num ) const { return isValid( num ); }
bool FieldRow::isValid( int num ){
	switch( num ){
	case 2:
	case 3:
	case 4:
	case 9:
	case 10:
	case 12:
		return true;
	default:
		break;
	}
	return false;
}

int FieldRow::handleRoll( int die1, int die2, TableState, QString& msg ){
	int win=0;
	const int NUM=die1+die2;

	if( mbet && isValidNumber( NUM ) ){
		if( NUM==12 && tripleOnTwelve ){
			msg=QObject::tr( "Field bets pay 3:1 odds on 12" );
			win=mbet*4;
		}
		else if( 12==NUM || 2==NUM ){
			msg=QObject::tr( "Field bets pay 2:1 odds on %1" ).arg( NUM );
			win=mbet*3;
		}
		else{
			msg=QObject::tr( "Field bets pay even money on winners" );
			win=mbet*2;
		}
	}

	// all field bets are one-roll bets
	if( oao && win ) win-=mbet;
	else clearbets();
	return win;
}

Bet FieldRow::getBetFor( int ) const { return Bet( 0, mbet, Bet::FIELD ); }
Bet FieldRow::ibetOn( int b, int, TableState ) { return bet( b ); }
Bet FieldRow::bet( int newbet ){
	mbet+=newbet;
	return getBetFor( 0 );
}

vector<Bet> FieldRow::bets() const {
	vector<Bet> ret;
	Bet b=getBetFor( 0 );
	if( b.ok() ) ret.push_back( b );
	return ret;
}

