/***************************************************************************
 *   Copyright (C) 2005 by ryan p bobko   *
 *   ryan@ostrich-emulators.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kraps.h"

#include <qlabel.h>

#include <kmainwindow.h>
#include <klocale.h>

#include "krapsengine.h"
#include "tableframe.h"
#include "fieldrow.h"
#include "player.h"

#include <kpopupmenu.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <kaction.h>

#include <time.h>
#include <stdlib.h>
#include <iostream>
using namespace std;


Kraps::Kraps() : KMainWindow( 0, "Kraps" ){ init( time( NULL ) ); }
Kraps::Kraps( long seed ) : KMainWindow( 0, "Kraps" ){ init( seed );}
Kraps::~Kraps(){}

void Kraps::init( long seed ){
	// set the shell's ui resource file
	setXMLFile("krapsui.rc");

	srand( seed );
	cout<<"seed="<<seed<<endl;


	QStatusBar * sbar=statusBar();
	info=new QLabel( sbar );
	sbar->addWidget( info, 10 );
	
	betinfo=new QLabel( sbar );
	betinfo->setAlignment( Left );
	sbar->addWidget( betinfo, 5 );

	allbetinfo=new QLabel( sbar );
	allbetinfo->setAlignment( Left );
	sbar->addWidget( allbetinfo, 5 );

	Player * player=new Player( 0 );
	KrapsEngine * engine=new KrapsEngine();
	frame=new TableFrame( *engine, *player, this );
	setCentralWidget( frame );

	connect( frame, SIGNAL( tableBets( int ) ), SLOT( tabets( int ) ) );
	connect( frame, SIGNAL( totalBets( int ) ), SLOT( ttbets( int ) ) );
	ttbets( 0 );

	KMenuBar * menu=menuBar();	
	KPopupMenu * file=new KPopupMenu( this );
	menu->insertItem( i18n( "&Casino" ), file );

	KAction * quit=KStdAction::quit( this, SLOT( close() ), actionCollection() );
	quit->plug( file );
	
	KAction * cash=new KAction( i18n( "Hit the &ATM" ), KShortcut( CTRL+Key_A ), 
															this, SLOT( atm() ), actionCollection(), "atm" );
	cash->plug( file );

	KPopupMenu * instr=new KPopupMenu( this );
	menu->insertItem( i18n( "&Dealer Instructions" ), instr );

	KToggleAction * maxodds=new KToggleAction( i18n( "&Max Odds" ), 
																						 KShortcut( CTRL+Key_M ),
																						 actionCollection(), "maxodds" );
	connect( maxodds, SIGNAL( toggled( bool ) ), frame, SLOT(maxodds( bool ) ) );
	maxodds->plug( instr );
	frame->maxodds( true );
	maxodds->setChecked( true );

	KToggleAction * dumbbets=new KToggleAction( i18n( "&Allow Dumb Bets" ), 
																							KShortcut( CTRL+Key_D ), 
																							actionCollection(), "dumbbets" );
	connect( dumbbets, SIGNAL( toggled( bool ) ),
					 frame, SLOT(dumbbets( bool ) ) );
	dumbbets->plug( instr );

	KToggleAction * oao=new KToggleAction( i18n( "&Off-and-On Bets" ), 
																				 KShortcut( CTRL+Key_O ), 
																				 actionCollection(), "oao" );
	connect( oao, SIGNAL( toggled( bool ) ), engine, SLOT( offandon( bool ) ) );
	oao->plug( instr );
	oao->setChecked( true );

	KToggleAction * threefourfive=new KToggleAction( i18n( "&Use 3x4x5x Odds" ),
																									 KShortcut( CTRL+Key_U ), 
																									 actionCollection(), "345" );
	connect( threefourfive, SIGNAL( toggled( bool ) ), 
					 engine, SLOT( bigOdds( bool ) ) );
	connect( threefourfive, SIGNAL( toggled( bool ) ), 
					 player, SLOT( bigOdds( bool ) ) );
	threefourfive->plug( instr );

	KToggleAction * buys=new KToggleAction( i18n( "&Buy Place Bets" ), 
																					KShortcut( CTRL+Key_B ), 
																					actionCollection(), "buy" );
	connect( buys, SIGNAL( toggled( bool ) ), 
					 engine, SLOT( buyPlaces( bool ) ) );
	buys->plug( instr );
	buys->setChecked( true );


	connect( engine, SIGNAL( buttonOn( int ) ), 
					 this, SLOT( buttonOn( int ) ) );
	connect( engine, SIGNAL( number( int, int, TableState ) ), 
					 this, SLOT( dice( int, int, TableState ) ) );
	connect( engine, SIGNAL( payout( int, int, const QString& ) ), 
					 this, SLOT( winner( int, int, const QString& ) ) );
	atm();
}

void Kraps::dice( int d1, int d2, TableState ts ){
	info->setText( dealerSays( d1, d2, ts ) );
}

void Kraps::buttonOn( int i ){
	button=i; 
	if( i==0 ) return;

	int r=rand()%3;
	QString str;
	if( r==1 ) str=i18n( QString( "Button on %1" ).arg( i ) );
	else if( r==2 ) str=i18n( QString( "Comin' out %1" ).arg( i ) );
	else str=i18n( QString( "%1 is the number" ).arg( i ) );
	info->setText( str );
}

QString Kraps::dealerSays( int d1, int d2, TableState state ) const {
	int tot=d1+d2;
	QString str;

	if( d1==d2 && tot!=12 && tot!=2 ){
		str=i18n( "%1 the hard way" ).arg( QString::number( tot ) );
		if( button==tot && ClearingMark==state ) str.append( i18n( " winner!" ) );
	}
	else if( tot==7 ){
		if( state==ClearingMark ) str=i18n( "Seven out" );
		else str=i18n( "Seven winner!" );
	}
	else if( tot==button && ClearingMark==state ) 
		str=i18n( "%1 winner!" ).arg( QString::number( tot ) );
	else if( tot==11 ){
		int r=rand()%3;
		if( r==1 ) str=i18n( "Eleven eleven eleven" );
		else if( r==2 ) str=i18n( "Yo eleven!" );
		else str=i18n( "Yo eleven. Winner on the Come and Pass." );
	}
	else if( tot==2 || tot==3 || tot==12 ) 
		str=i18n( QString( "Craps %1" ).arg( tot ) );
	else if( !FieldRow::isValid( tot ) ){
		int r=rand()%3;
		if( r==1 ) str=i18n( QString( "No field %1" ).arg( tot ) );
		else if( r==2 ) str=QString::number( tot );
		else str=i18n( QString( "%1 No field %2" ).arg( tot ).arg( tot ) );
	}
	else if( tot==8 ) str=i18n( "Easy eight" );
	else str=QString( "%1, %2" ).arg( QString::number( d1 ) ).arg( QString::number( d2 ) );
	return str;
}

void Kraps::winner( int win, int number, const QString& comment ){
	int rr=frame->rolls();
	if( win>0 ) cout<<"Roll "<<rr<<": won "<<win<<" on "<<number<<". "<<comment<<endl;
	else cout<<"Roll "<<rr<<": used "<<0-win<<" for "<<number<<". "<<comment<<endl;
}

void Kraps::atm(){ frame->win( 100 ); }

void Kraps::tabets( int b ){
	betinfo->setText( i18n( QString( "Bets on Table: %1" ).arg( b ) ) );
}

void Kraps::ttbets( int b ){
	allbetinfo->setText( i18n( QString( "Total Bets: %1" ).arg( b ) ) );
}



#include "kraps.moc"
