/***************************************************************************
 *   Copyright (C) 2005 by ryan p bobko   *
 *   ryan@ostrich-emulators.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KRAPS_H_
#define _KRAPS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include "constants.h"

class QLabel;
class TableFrame;
class KrapsEngine;

/**
 * @short Application Main Window
 * @author ryan p bobko <ryan@ostrich-emulators.com>
 * @version 0.1
 */
class Kraps : public KMainWindow
{
Q_OBJECT

public:
	Kraps();
	Kraps( long seed );
	~Kraps();

protected:
	QLabel * info, * betinfo, * allbetinfo;
	TableFrame * frame;
	int button;

	void init( long seed );
	QString dealerSays( int d1, int d2, TableState ) const;

	public slots:
	void dice( int, int, TableState );
	void buttonOn( int );
	void winner( int, int, const QString& );
	void atm();
	void tabets( int );
	void ttbets( int );
};

#endif // _KRAPS_H_
