/***************************************************************************
 *   Copyright (C) 2005 by ryan p bobko   *
 *   ryan@ostrich-emulators.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "krapsengine.h"
#include "fieldrow.h"
#include "buttonbar.h"
#include "pitbets.h"

#include <iostream>

KrapsEngine::KrapsEngine() : QObject() {
	oao=true;
	
	comerow=new ComeRow( 2, 2, 2 );
	dontcomerow=new DontComeRow( 2, 2, 2 );
	placerow=new PlaceRow();
	dontplacerow=new DontPlaceRow();
	fieldrow=new FieldRow();
	big68s=new Big68Bets();
	hornbets=new HornBets();
	hardways=new HardwayBets();
	passer=new LineBet( Bet::PASS );
	comer=new LineBet( Bet::COME );
	dontpasser=new LineBet( Bet::NOPASS );
	dontcomer=new LineBet( Bet::NOCOME );
	
	BetLocation * locations[]={ comerow, placerow, dontcomerow,	dontplacerow, 
															fieldrow, hornbets, big68s, hardways,
															passer, comer, dontpasser, dontcomer };
	const int LOCS=12;
	for( int i=0; i<LOCS; i++ ){
		locations[i]->setOffAndOn( oao );
		connect( locations[i], SIGNAL( removedBet( const Bet& ) ),
						 this, SLOT( erasedBet( const Bet& ) ) );
	}

	buyPlaces( true );
	reset();
}


KrapsEngine::~KrapsEngine(){}


Bet KrapsEngine::place( int bet, int number, bool no ){
	if( number==button ) return InvalidNumber;
	return ( no ? dontplacerow->betOn( bet, number, state ) : placerow->betOn( bet, number, state ) );
}

Bet KrapsEngine::come( int bet, bool no ){ 
	return ( no ? dontcomer->bet( bet, state ) : comer->bet( bet, state ) );
}

Bet KrapsEngine::pass( int bet, bool no ){
	return ( no ? dontpasser->bet( bet, state ) : passer->bet( bet, state ) );
}

Bet KrapsEngine::field( int bet ){ return fieldrow->bet( bet ); }

Bet KrapsEngine::odds( int bet, int number, bool no ){
	return( no ? dontcomerow->oddsOn( bet, number, state ) : comerow->oddsOn( bet, number, state ) );
}

Bet KrapsEngine::anycraps( int bet ){
	return hornbets->betOn( bet, HornBets::ANYCRAPS, state );
}

Bet KrapsEngine::big( int bet, int number ){
	return big68s->betOn( bet, number, state );
}

Bet KrapsEngine::horn( int bet, int number ){
	return hornbets->betOn( bet, number, state );
}

Bet KrapsEngine::hardway( int bet, int number ){
	return hardways->betOn( bet, number, state );
}

const char * KrapsEngine::errmsg( int err ) const { if( err ); return "err"; }

TableState KrapsEngine::tableState() const { return state; }

void KrapsEngine::roll(){
	int die1=rand()%6+1;
	int die2=rand()%6+1;

	/*
	static int nroll=0;
	static int d1s[]={ 4, 4, 3, 3, 4, 5, 4, 4, 4, 4, 4 };
	static int d2s[]={ 2, 4, 5, 6, 1, 4, 3, 1, 1, 5, 3 };

	die1=d1s[nroll];
	die2=d2s[nroll];
	nroll++;
	*/
	int dice=die1+die2;
	bool toprow=TopRow::isValid( dice );

	if( ( dice==7 && button ) || button==dice ) state=ClearingMark;
	else if( !button ){
		if( toprow ){
			state=PlacingMark;
			button=dice;
		}
		else state=NoMark;
	}
	else state=Normal;

	// for off-and-on to work for the come and dont' come bars, we
	// need to know if we're paying out anything
	bool dooao=false;
	bool ndooao=false;
	if( oao && state==Normal ){ // only do oao in Normal situations
		Bet b=comerow->getBetFor( die1+die2 );
		if( b.bet>0 ) dooao=true;
		
		b=dontcomerow->getBetFor( die1+die2 );
		if( b.bet>0 ) ndooao=true;
	}

	int win=handleTable( die1, die2 );

	if( state==ClearingMark ){
		button=0;
		buttonOn( button );

		if( 7!=dice ){
			// we have a winner, so we need to move the money from the come line
			// to the toprow someplace
			int val=comer->val();
			if( val ){
				emit addBet( comerow->betOn( val, dice, Normal ) );
				comer->clearbets();
			}
			
			val=dontcomer->val();
			if( val ){
				emit addBet( dontcomerow->betOn( val, dice, Normal ) );
				dontcomer->clearbets();
			}
		}
	}
	else if( state==PlacingMark ){
		state=Normal;
		buttonOn( button );

		// move the pass bets to the comerow
		int val=passer->val();
		if( val ){
			emit addBet( comerow->betOn( val, button, state ) );
			passer->clearbets();
		}
		
		val=dontpasser->val();
		if( val ){
			emit addBet( dontcomerow->betOn( val, button, state ) );
			dontpasser->clearbets();
		}
	}
	else if( Normal==state ){
		// move the come bets to the comerow
		if( toprow ){
			int val=comer->val();
			if( val ){
				emit addBet( comerow->betOn( val, dice, state ) );
				if( dooao ) win-=val;
				else comer->clearbets();
			}
			
			val=dontcomer->val();
			if( val ){
				emit addBet( dontcomerow->betOn( val, dice, state ) );
				if( ndooao ) win-=val;
				else dontcomer->clearbets();
			}
		}
	}

	emit number( die1, die2 );
	emit number( die1, die2, state );
	if( win ) emit payout( win );

	// we're done clearing, and now we don't have a marker anymore
	if( ClearingMark==state ) state=NoMark;
}
 
int KrapsEngine::handleTable( int die1, int die2 ){
	int win=0;
	BetLocation * locations[]={ comerow, placerow, dontcomerow, dontplacerow, 
															fieldrow, hornbets, big68s, hardways,	passer, 
															comer, dontpasser, dontcomer };
	const int LOCS=12;
	for( int i=0; i<LOCS; i++ ){
		QString str="";
		int pay=locations[i]->handleRoll( die1, die2, state, str );
		win+=pay;
		if( pay ) emit payout( pay, die1+die2, str );
	}

	return win;
}

void KrapsEngine::reset(){
	BetLocation * locations[]={ comerow, placerow, dontcomerow,
		dontplacerow, fieldrow, hornbets, big68s, hardways,
		passer, comer, dontpasser, dontcomer };
	const int LOCS=12;
	for( int i=0; i<LOCS; i++ ) locations[i]->clearbets();
	state=NoMark;
	button=0;
}

void KrapsEngine::offandon( bool b ){
	oao=b;
	BetLocation * locations[]={ comerow, placerow, dontcomerow,
															dontplacerow, fieldrow, hornbets, big68s,
															hardways,	passer, comer, dontpasser, dontcomer };
	const int LOCS=12;
	for( int i=0; i<LOCS; i++ )	locations[i]->setOffAndOn( oao );
}

vector<Bet> KrapsEngine::bets() const {
	vector<Bet> ret;
	BetLocation * locations[]={ comerow, placerow, dontcomerow,	dontplacerow, 
															fieldrow, hornbets, big68s, hardways,
															passer , comer, dontpasser, dontcomer };
	const int LOCS=12;

	for( int i=0; i<LOCS; i++ ){
		vector<Bet> bets=locations[i]->bets();
		ret.insert( ret.end(), bets.begin(), bets.end() );
	}
	return ret;
}

void KrapsEngine::erasedBet( const Bet& b ){ emit eraseBet( b ); }

Bet KrapsEngine::getTopRowBetFor( int number, bool no ) const {
	return ( no ? dontcomerow->getBetFor( number ) : comerow->getBetFor( number ) );
}

void KrapsEngine::bigOdds( bool use345 ){
	if( use345 ) tableOdds( 3, 4, 5 );
	else tableOdds( 2, 2, 2 );
}

void KrapsEngine::buyPlaces( bool yes ){
	placerow->buyPlaces( yes );
	dontplacerow->buyPlaces( yes );	
}

void KrapsEngine::tableOdds( int sixeight, int fivenine, int fourten ){
	comerow->setOdds( sixeight, fivenine, fourten );
	dontcomerow->setOdds( sixeight, fivenine, fourten );
}

#include "krapsengine.moc"
