/***************************************************************************
 *   Copyright (C) 2005 by ryan p bobko   *
 *   ryan@ostrich-emulators.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KRAPSENGINE_H
#define KRAPSENGINE_H

#include <qobject.h>
#include "constants.h"
#include "bet.h"

#include <memory>
#include <vector>
using namespace std;

class FieldRow;
class ComeRow;
class PlaceRow;
class DontComeRow;
class DontPlaceRow;
class Big68Bets;
class HornBets;
class HardwayBets;
class LineBet;

/**
@author ryan p bobko
*/
class KrapsEngine : public QObject{
	Q_OBJECT
		public:
	KrapsEngine();
	~KrapsEngine();

	Bet place( int bet, int number, bool no =false );
	Bet come( int bet, bool no =false );
	Bet pass( int bet, bool no =false );
	Bet field( int bet );
	Bet odds( int bet, int number =0, bool no =false );
	Bet horn( int bet, int number );
	Bet hardway( int bet, int number );
	Bet anycraps( int bet );
	Bet big( int bet, int number );
	Bet getTopRowBetFor( int number, bool dont ) const;

	const char * errmsg( int err ) const;
	vector<Bet> bets() const;

	void tableOdds( int sixeight, int fivenine, int fourten );
	TableState tableState() const;

protected:
	int button;
	bool oao, buys;
	TableState state;

	ComeRow * comerow;
	PlaceRow * placerow;
	DontComeRow * dontcomerow;
	DontPlaceRow * dontplacerow;
	FieldRow * fieldrow;
	HornBets * hornbets;
	Big68Bets* big68s;
	HardwayBets * hardways;
	LineBet * passer, * comer, * dontpasser, * dontcomer;

	int handleTable( int die1, int die2 );
	void reset();

signals:
	void number( int die1, int die2 );
	void number( int die1, int die2, TableState );
	void buttonOn( int dice );
	void payout( int winnings );
	void payout( int winnings, int number, const QString& );
	void eraseBet( const Bet& );
	void addBet( const Bet& );

public slots:
	void roll();
	void offandon( bool );
	void buyPlaces( bool );
	void erasedBet( const Bet& );
	void bigOdds( bool threefourfive );
};

#endif
