
#include "pitbets.h"

#include <qobject.h>

#include <iostream>
using namespace std;

/***************/
/*** BIG 6&8 ***/
/***************/
Big68Bets::Big68Bets(){ bet6=bet8=0; }

void Big68Bets::clearbets(){ 
	if( bet6 ){
		const Bet b=getBetFor( 6 );
		bet6=0;
		emit removedBet( b );
	}
	if( bet8 ){
		const Bet b=getBetFor( 8 );
		bet8=0;
		emit removedBet( b );
	}
}

bool Big68Bets::isValidNumber( int num ) const { return( 6==num || 8==num ); }

int Big68Bets::handleRoll( int die1, int die2, TableState, QString& msg ){
	int win=0;
	const int NUM=die1+die2;

	if( isValidNumber( NUM ) ){
		if( bet6 && 6==NUM ){ 
			msg=QObject::tr( "Big 6 bets pay even money" );
			if( oao ) win=bet6;
			else {
				win=bet6*2;
				clearbets();
			}
		}
		else{
			msg=QObject::tr( "Big 8 bets pay even money" );
			if( oao ) win=bet8;
			else {
				win=bet8*2;
				clearbets();
			}
		}
	}
	return win;
}

Bet Big68Bets::getBetFor( int number ) const {
	if( 6==number ) return Bet( 6, bet6, Bet::BIG );
	else if( 8==number ) return Bet( 8, bet8, Bet::BIG );
	return Bet( NoBet );
}

Bet Big68Bets::ibetOn( int bet, int num, TableState ts ) {
	if( Normal!=ts ) return Bet( WrongTableState );

	if( 6==num ) bet6+=bet;
	else bet8+=bet;
	return getBetFor( num );
}

vector<Bet> Big68Bets::bets() const {
	vector<Bet> ret;
	Bet b6=getBetFor( 6 );
	Bet b8=getBetFor( 8 );
	if( b6.ok() ) ret.push_back( b6 );
	if( b8.ok() ) ret.push_back( b8 );
	return ret;
}




/****************/
/*** HARDWAYS ***/
/****************/
HardwayBets::HardwayBets(){ for( int i=0; i<11; i++ ) mbets[i]=0; }
void HardwayBets::clearbets(){
	for( int i=0; i<11; i++ ){
		if( mbets[i]>0 ){
			const Bet b=getBetFor( i );
			mbets[i]=0; 
			emit removedBet( b );
		}
	}
}

bool HardwayBets::isValidNumber( int num ) const { 
	switch( num ){
	case 4:
	case 6:
	case 8:
	case 10:
		return true;
	default:
		return false;
	}
}

int HardwayBets::handleRoll( int die1, int die2, TableState ts, QString& msg ){
	int win=0;
	const int NUM=die1+die2;

	bool stillwin=false;
	if( ClearingMark ){
		if( 7==NUM ) clearbets();
		else stillwin=true;
	}

	if( stillwin || ( Normal==ts && isValidNumber( NUM ) ) ){
		if( mbets[NUM] ){
			if( die1==die2 ){ // we're going to win something!
				switch( NUM ){			
				case 4:
				case 10:
					win=mbets[NUM]*8;
					msg=QObject::tr( "Hardway winners pay 7:1 odds on %1" ).arg( NUM );
					break;
				case 6:
				case 8:
					win=mbets[NUM]*10;
					msg=QObject::tr( "Hardway winners pay 9:1 odds on %1" ).arg( NUM );
					break;
				}
			}
			else{
				Bet b=getBetFor( NUM );
				mbets[NUM]=0;
				emit removedBet( b );		
			}

			// unless we're doing off-and-on, the bet comes down on a win
			if( win ){
				if( oao ) win-=mbets[NUM];
				else{
					Bet b=getBetFor( NUM );
					mbets[NUM]=0;
					emit removedBet( b );
				}
			}
		}
	}
	
	return win;
}

Bet HardwayBets::getBetFor( int num ) const {
	return Bet( num, mbets[num], Bet::HARDWAY );
}

Bet HardwayBets::ibetOn( int bet, int num, TableState ts ) {
	if( Normal==ts ){
		mbets[num]+=bet;
		return getBetFor( num );
	}
	return Bet( WrongTableState );
}

vector<Bet> HardwayBets::bets() const {
	vector<Bet> ret;
	for( int i=0; i<11; i++ ){
		Bet b=getBetFor( i );
		if( b.ok() ) ret.push_back( b );
	}
	return ret;
}



/*****************/
/*** Horn Bets ***/
/*****************/
const int HornBets::ANYCRAPS=1;
const int HornBets::HORN=0;

HornBets::HornBets(){ 
	anyc=0;
	for( int i=0; i<13; i++ ) mbets[i]=0; 
}

void HornBets::clearbets(){ 
	if( anyc>0 ){
		const Bet b=getBetFor( ANYCRAPS );
		anyc=0;
		emit removedBet( b );
	}

	for( int i=0; i<13; i++ ){
		if( mbets[i]>0 ){
			const Bet b=getBetFor( i );
			mbets[i]=0; 
			emit removedBet( b );
		}
	}
}

bool HornBets::isValidNumber( int num ) const {
	switch( num ){
	case HORN:
	case ANYCRAPS:
	case 2:
	case 3:
	case 7:
	case 11:
	case 12:
		return true;
	default:
		return false;
	}
}

int HornBets::handleRoll( int die1, int die2, TableState, QString& msg ){
	int win=0;
	const int NUM=die1+die2;

	if( anyc && ( 2==NUM || 3==NUM || 12==NUM ) ){
		// anycraps pays 7:1
		msg=QObject::tr( "Any Craps pays 7:1 odds and bet is returned" );
		win=anyc*8;
	}

	if( isValidNumber( NUM ) ){
		if( mbets[NUM] ){
			QString st;
			switch( NUM ){
			case 2:
			case 12:
				st="30:1";
				win+=31*mbets[NUM];
				break;
			case 3:
			case 11:
				st="15:1";
				win+=16*mbets[NUM];
				break;
			case 7:
				st="4:1";
				win+=5*mbets[NUM];
				break;				
			}
			msg+=QObject::tr( "Horn bets pay %1 odds on %1 and bet is returned" ).arg( st ).arg( NUM );
		}
	}

	if( win && oao )
		cout<<"FIXME: hornbets don't handle off-and-on betting"<<endl;
	clearbets(); // these are one-roll bets
	return win;
}

Bet HornBets::ibetOn( int bet, int num, TableState ) {
	if( HORN==num ){
		int b=bet/4;
		int numbs[]={ 2, 3, 11, 12 };
		for( int i=0; i<4; i++ ) mbets[numbs[i]]+=b;
	}
	else if( num==ANYCRAPS ) anyc+=bet;
	else mbets[num]+=bet;

	return OK;
}

vector<Bet> HornBets::bets() const {
	vector<Bet> ret;
	Bet b=getBetFor( ANYCRAPS );
	if( b.ok() ) ret.push_back( b );
	for( int i=0; i<13; i++ ){
		Bet b=getBetFor( i );
		if( b.ok() ) ret.push_back( b );
	}
	return ret;
}

Bet HornBets::getBetFor( int number ) const {
	if( number==ANYCRAPS ) return Bet( 0, anyc, Bet::ANYC );
	else return Bet( number, mbets[number], Bet::HORN );
}
