
#ifndef PITBETS
#define PITBETS

#include "betlocation.h"

#include <vector>
using namespace std;

class QString;

class Big68Bets : public BetLocation {
 public:
	Big68Bets();
	void clearbets();
	int handleRoll( int die1, int die2, TableState ts, QString& msg );
	Bet ibetOn( int bet, int number, TableState ts );
	Bet getBetFor( int number ) const;
	vector<Bet> bets() const;

 protected:
	int bet6, bet8;

	bool isValidNumber( int i ) const;
};


class HardwayBets : public BetLocation {
 public:
	HardwayBets();
	void clearbets();
	int handleRoll( int die1, int die2, TableState ts, QString& msg );
	Bet ibetOn( int bet, int number, TableState ts );
	Bet getBetFor( int number ) const;
	vector<Bet> bets() const;

 protected:
	int mbets[11];

	bool isValidNumber( int i ) const;
};


class HornBets : public BetLocation {
 public:
	static const int ANYCRAPS, HORN;

	HornBets();
	void clearbets();
	int handleRoll( int die1, int die2, TableState ts, QString& msg );
	Bet ibetOn( int bet, int number, TableState ts );
	Bet getBetFor( int number ) const;
	vector<Bet> bets() const;

 protected:
	int mbets[13]; // 12 is a possible hornbet winner
	int anyc;
	bool isValidNumber( int i ) const;
};

#endif
