
#include <iostream>

#include "tableframe.h"
#include "krapsengine.h"
#include "betlocation.h"
#include "pitbets.h"
#include "diedisplay.h"
#include "player.h"

#include <kglobal.h>
#include <kstandarddirs.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qevent.h>

const QRgb TableFrame::PASS=qRgb( 0, 0, 0xFF );
const QRgb TableFrame::NOPASS=qRgb( 0x80, 0x80, 0x80 );
const QRgb TableFrame::COME=qRgb( 0, 0, 0xFA );
const QRgb TableFrame::NOCOME=qRgb( 0x80, 0x80, 0x88 );
const QRgb TableFrame::FIELD=qRgb( 0x80, 0x80, 0 );
const QRgb TableFrame::BIG6=qRgb( 0xC1, 0xC1, 0xC1 );
const QRgb TableFrame::BIG8=qRgb( 0xC0, 0xC0, 0xC0 );
const QRgb TableFrame::PASSODDS=qRgb( 0x93, 0xD2, 0x93 );

const QRgb TableFrame::FOUR=qRgb( 0xFF, 0xDA, 0x14 );
const QRgb TableFrame::NOFOUR=qRgb( 0xFF, 0xDB, 0x14 );
const QRgb TableFrame::PFOUR=qRgb( 0xFF, 0xCB, 0x34 );

const QRgb TableFrame::FIVE=qRgb( 0xFF, 0xA2, 0x66 );
const QRgb TableFrame::NOFIVE=qRgb( 0xFF, 0xA3, 0x66 );
const QRgb TableFrame::PFIVE=qRgb( 0xFF, 0x8F, 0x73 );

const QRgb TableFrame::SIX=qRgb( 0xD1, 0x3A, 0x3A );
const QRgb TableFrame::NOSIX=qRgb( 0xD1, 0x3B, 0x3A );
const QRgb TableFrame::PSIX=qRgb( 0xC3, 0x4B, 0x4B );

const QRgb TableFrame::EIGHT=qRgb( 0x90, 0x23, 0x23 );
const QRgb TableFrame::NOEIGHT=qRgb( 0x90, 0x24, 0x23 );
const QRgb TableFrame::PEIGHT=qRgb( 0x89, 0x13, 0x13 );

const QRgb TableFrame::NINE=qRgb( 0xC8, 0x58, 0x58 );
const QRgb TableFrame::NONINE=qRgb( 0xC8, 0x59, 0x58 );
const QRgb TableFrame::PNINE=qRgb( 0x95, 0x47, 0x47 );

const QRgb TableFrame::TEN=qRgb( 0xC0, 0x1D, 0x1D );
const QRgb TableFrame::NOTEN=qRgb( 0xC0, 0x1E, 0x1D );
const QRgb TableFrame::PTEN=qRgb( 0xEE, 0x13, 0x13 );

const QRgb TableFrame::ANY7=qRgb( 0x8B, 0x88, 0x44 );
const QRgb TableFrame::H2=qRgb( 0xA8, 0xA3, 0x22 );
const QRgb TableFrame::H12=qRgb( 0xC3, 0xBF, 0x47 );
const QRgb TableFrame::YO=qRgb( 0x8B, 0x87, 0x24 );
const QRgb TableFrame::H3=qRgb( 0x7A, 0x76, 0x0B );
const QRgb TableFrame::HORN=qRgb( 0xC1, 0xBC, 0x27 );
const QRgb TableFrame::ANYC=qRgb( 0xCC, 0xC7, 0x3B );
const QRgb TableFrame::H4=qRgb( 0x43, 0xBE, 0xB1 );
const QRgb TableFrame::H6=qRgb( 0x15, 0x9C, 0x8E );
const QRgb TableFrame::H8=qRgb( 0x26, 0xAF, 0xA1 );
const QRgb TableFrame::H10=qRgb( 0x0B, 0xA4, 0x94 );



TableFrame::TableFrame( KrapsEngine& e, Player& pl, 
												QWidget * p, const char * n ) : QFrame( p, n ){

	engine=&e;
	player=&pl;
	modds=false;
	dbets=false;
	allbets=0;

	tablemask=new QImage( locate("data", "kraps/tablemask.png") );
	QImage tbl( locate("data", "kraps/table.png") );

	tablepix=new QPixmap();
	tablepix->convertFromImage( tbl );

	//chippix=new QPixmap( "images/smallchip.xpm" );

	setMinimumSize( tbl.size() );

	die1=new DieDisplay( this );
	die2=new DieDisplay( this );
	connect( die1, SIGNAL( clicked() ), SLOT( roll() ) );
	connect( die2, SIGNAL( clicked() ), SLOT( roll() ) );

	cash=new CashDisplay( this );
	connect( player, SIGNAL( bankIs( int ) ), cash, SLOT( recash( int ) ) );

	die1->setGeometry( 5, 5, 50, 50 );
	die2->setGeometry( 55, 5, 50, 50 );
	cash->setGeometry( 18, 68, 75, 75 );

	connect( engine, SIGNAL( number( int , int ) ), 
					 this, SLOT( number( int, int ) ) );
	connect( engine, SIGNAL( buttonOn( int ) ), 
					 this, SLOT( buttonOn( int ) ) );
	connect( engine, SIGNAL( payout( int ) ), 
					 this, SLOT( win( int ) ) );
	connect( engine, SIGNAL( eraseBet( const Bet& ) ), 
					 this, SLOT( refreshBet( const Bet& ) ) );
	connect( engine, SIGNAL( addBet( const Bet& ) ), 
					 this, SLOT( refreshBet( const Bet& ) ) );
	buttonOn( 0 );
	nrolls=1;

	tips=new CrapsTip( engine, this );
}

TableFrame::~TableFrame(){
	delete tablemask;
	delete tablepix;
	//delete chippix;
	delete tips;
}

void TableFrame::drawContents( QPainter * ){
	QPixmap pm( size() );
	QPainter p;
	p.begin( &pm, this );

	p.drawPixmap( 0, 0, *tablepix );

	p.setBrush( Qt::white );
	p.setPen( Qt::white );
	p.drawPie( buttonx+7, 18, 36, 36, 0, 5760 );
	p.setPen( Qt::black );
	p.drawArc( buttonx+7, 18, 36, 36, 0, 5760 );

	int totbet=0;
	vector<Bet> bets=engine->bets();
	if( bets.size()>0 ){
		for( vector<Bet>::iterator iter=bets.begin(); iter!=bets.end(); iter++ ){
			Bet b=*iter;
			int xx=0;
			int yy=0;

			//cout<<"t"<<b.type<<" n"<<b.number<<" b"<<b.bet<<" o"<<b.odds<<endl;
			getBetLocation( b, xx, yy );

			if( b.odds ){
				if( b.type==Bet::PASS || ( b.type==Bet::NUMBER && b.number==button ) ){
					drawChipAt( &p, xx, yy+40, &b, true );
				}
				else if( b.type==Bet::NOPASS || 
								 ( b.type==Bet::NONUMBER && b.number==button ) ){
					drawChipAt( &p, xx, yy+75, &b, true );
				}
				else drawChipAt( &p, xx, yy+5 );
			}
			drawChipAt( &p, xx, yy, &b );

			totbet+=b.odds+b.bet;
		}
	}
	p.end();
	bitBlt( this, 0, 0, &pm );

	emit tableBets( totbet );
}

void TableFrame::drawChipAt( QPainter * p, int x, int y, 
														 const Bet * bet, bool doodds ){

	QColor chipcolor( 155, 53, 57 );
	p->setPen( chipcolor );
	p->setBrush( chipcolor );
	//p->setPen( Qt::red );
	//p->setBrush( Qt::red );
	p->drawPie( x+1, y+1, 20, 20, 0, 5760 );
	p->setPen( Qt::white );
	p->drawArc( x+1, y+1, 20, 20, 0, 5760 );

	p->setPen( chipcolor );
	p->setBrush( chipcolor );
	p->drawPie( x, y, 20, 20, 0, 5760 );
	p->setPen( Qt::white );
	p->drawArc( x, y, 20, 20, 0, 5760 );
	p->setPen( Qt::black );	

	//p->drawPixmap( x, y, *chippix );
	
	if( bet ){
		QRect r( x, y, 20, 20 );
		p->setPen( Qt::white );
		p->drawText( r, AlignCenter, 
								 QString::number( doodds ? bet->odds : bet->bet ) );

		if( bet->buy ){
			p->setBrush( Qt::white );
			p->drawPie( x+5, y+5, 10, 10, 0, 5760 );
			p->setPen( Qt::black );
			p->drawArc( x+5, y+5, 10, 10, 0, 5760 );
		}
	}
}

void TableFrame::getBetLocation( const Bet& b, int &xx, int &yy ) const {
	xx=205;
	yy=85;

	// draw the money on the pass line
	if( b.type==Bet::PASS || ( b.type==Bet::NUMBER && b.number==button ) ){
		yy=315;
	}
	else if( b.type==Bet::NOPASS || 
					 ( b.type==Bet::NONUMBER && b.number==button ) ){
		yy=275;
	}
	else if( b.type==Bet::COME ) yy=195;
	else if( b.type==Bet::NOCOME ){
		yy=80;
		xx=465;
	}
	else if( b.type==Bet::FIELD ) yy=235;
	else if( b.type==Bet::ANYC ){
		xx=72;
		yy=370;
	}
	else if( b.type==Bet::BIG ){
		if( 6==b.number ){
			xx=470;
			yy=280;
		}
		else if( 8==b.number ){
			xx=505;
			yy=240;
		}
	}
	else if( b.type==Bet::HARDWAY ){
		if( b.number==4 || b.number==10 ) yy=230;
		else yy=185;
		if( b.number==4 || b.number==6 ) xx=45;
		else xx=115;
	}
	else if( b.type==Bet::HORN ){
		if( b.number==7 ){
			xx=72;
			yy=274;
		}
		else{
			if( b.number==2 || b.number==3 ) xx=30;
			else xx=125;
			if( b.number==2 || b.number==12 ) yy=305;
			else yy=340;
		}
	}
	else if( b.type==Bet::NUMBER || b.type==Bet::PLACE 
					 || b.type==Bet::NONUMBER ){
		switch( b.number ){
		case 4:
			xx=113;
			break;
		case 5:
			xx=167;
			break;
		case 6:
			xx=221;
			break;
		case 8:
			xx=275;
			break;
		case 9:
			xx=329;
			break;
		case 10:
			xx=383;
			break;
		}
		
		if( b.type==Bet::PLACE ) yy=65;
		if( b.type==Bet::NONUMBER ) yy=35;
	}
}


QRgb TableFrame::rgbUnder( const QPoint& p ) const {
	if( p.x()<0 || p.y()<0 ) return 0;
	return tablemask->pixel( p.x(), p.y() );
}

void TableFrame::mousePressEvent( QMouseEvent * qme ){
	QRgb pixel=rgbUnder( qme->pos() );
	if( 0==pixel ) return;

	bool rightmouse=( qme->stateAfter()&Qt::RightButton );
	bool ctrlmouse=( qme->stateAfter()&Qt::ControlButton );

	int bet=( ctrlmouse ? 1 : 5 );
	int mycash=player->cash();

	lastbet=Bet( Other );

	/*
	// horn and hardway bets are $1, so see if that's what we have
	const QRgb PITS[]={ ANY7, ANYC, H2, H3, H12, YO, H4, H6, H8, H10 };
	for( int i=0; i<10; i++ ){
		if( pixel==PITS[i] ) bet=1;
	}
	*/

	if( pixel==HORN ) bet=bet*4;
	else if( !dbets ){
		// should use even odds on 5 and 9, so odds should be even
		
		int button5or9=0;
		if( FIVE==pixel ) button5or9=5;
		else if( NINE==pixel ) button5or9=9;
		else if( PASSODDS==pixel && ( 5==button || 9==button ) ) button5or9=button;
		
		if( button5or9!=0 ){
			bet=player->oddsFor( engine->getTopRowBetFor( button5or9, false ) );
		}
	}

	if( mycash<bet ) return;

	if( !dbets ){
		// big 6/8 are dumb bets because placing the bet gives better odds
		if( pixel==BIG6 ) pixel=PSIX;
		else if( pixel==BIG8 ) pixel=PEIGHT;
	}

	// if the rightmouse is pressed, we'll remove a bet
	if( rightmouse ) bet=0-bet;

	// we can't remove bets from the pass or come lines
	if( pixel==PASS )	lastbet=engine->pass( bet );
	else if( pixel==NOPASS ) lastbet=engine->pass( bet, true );		

	else if( pixel==COME ) lastbet=engine->come( bet );
	else if( pixel==NOCOME ) lastbet=engine->come( bet, true );
	
	else if( pixel==PFOUR ) lastbet=engine->place(  bet, 4 );
	else if( pixel==PTEN ) lastbet=engine->place(   bet, 10 );

	else if( pixel==PFIVE ) lastbet=engine->place(  bet, 5 );
	else if( pixel==PNINE ) lastbet=engine->place(  bet, 9 );

	else if( pixel==BIG6 ) lastbet=engine->big( bet, 6 );
	else if( pixel==BIG8 ) lastbet=engine->big( bet, 8 );

	else if( pixel==PSIX ){
		// we need a positive bet for this calc to work. we'll switch back later
		if( rightmouse ) bet=0-bet;
		if( !dbets ){
			bet+=( 6-bet%6 );
			if( bet>mycash ) return;
		}
		if( rightmouse ) bet=0-bet;
		lastbet=engine->place(  bet, 6 );
	}
	else if( pixel==PEIGHT ){
		// we need a positive bet for this calc to work. we'll switch back later
		if( rightmouse ) bet=0-bet;
		if( !dbets ){
			bet+=( 6-bet%6 );
			if( bet>mycash ) return;
		}
		if( rightmouse ) bet=0-bet;
		lastbet=engine->place(  bet, 8 );
	}
	
	else if( pixel==FOUR ) lastbet=engine->odds(  bet, 4, false );
	else if( pixel==FIVE ) lastbet=engine->odds(  bet, 5, false );
	else if( pixel==SIX ) lastbet=engine->odds(   bet, 6, false );
	else if( pixel==EIGHT ) lastbet=engine->odds( bet, 8, false );
	else if( pixel==NINE ) lastbet=engine->odds(  bet, 9, false );
	else if( pixel==TEN ) lastbet=engine->odds(   bet, 10, false );
	else if( pixel==PASSODDS ){
		// pass odds count for pass line bets AND don't pass line bets
		// but we don't know which one until we've tried both
		lastbet=engine->odds( bet, button, false );
		if( !lastbet.ok() ) lastbet=engine->odds( bet, button, true );
	}

	else if( pixel==NOFOUR ) lastbet=engine->odds(  bet, 4, true );
	else if( pixel==NOFIVE ) lastbet=engine->odds(  bet, 5, true );
	else if( pixel==NOSIX ) lastbet=engine->odds(   bet, 6, true );
	else if( pixel==NOEIGHT ) lastbet=engine->odds( bet, 8, true );
	else if( pixel==NONINE ) lastbet=engine->odds(  bet, 9, true );
	else if( pixel==NOTEN ) lastbet=engine->odds(   bet, 10, true );
	
	else if( pixel==FIELD ) lastbet=engine->field( bet );

	else{
		if( pixel==ANYC )	lastbet=engine->anycraps( bet );
		
		else if( pixel==ANY7 ) lastbet=engine->horn( bet, 7 );
		else if( pixel==H2 )   lastbet=engine->horn( bet, 2 );
		else if( pixel==H3 )   lastbet=engine->horn( bet, 3 );
		else if( pixel==H12 )	 lastbet=engine->horn( bet, 12 );
		else if( pixel==YO )   lastbet=engine->horn( bet, 11 );
		else if( pixel==HORN ) lastbet=engine->horn( bet, HornBets::HORN );

		else if( pixel==H4 )  lastbet=engine->hardway( bet, 4 );
		else if( pixel==H6 )  lastbet=engine->hardway( bet, 6 );
		else if( pixel==H8 )  lastbet=engine->hardway( bet, 8 );
		else if( pixel==H10 ) lastbet=engine->hardway( bet, 10 );
	}

	//cout<<lastbet.result<<" "<<lastbet.ok()<<endl;

	if( lastbet.ok() ){
		// bets that are taken down have negative values
		// which may be different from what we thought
		// (like if we try to remove more than we bet)
		if( lastbet.bet<0 ) bet=lastbet.bet;

		win( -bet );
		refreshBet( lastbet );
	}
}

void TableFrame::buttonOn( int number ){
	button=number;

	switch( number ){
	case 4:
		buttonx=113;
		break;
	case 5:
		buttonx=167;
		break;
	case 6:
		buttonx=221;
		break;
	case 8:
		buttonx=275;
		break;
	case 9:
		buttonx=329;
		break;
	case 10:
		buttonx=383;
		break;
	default:
		buttonx=440; // button off
	}

	repaint( buttonx, 18, 36, 36, false );
}

void TableFrame::number( int d1, int d2 ){
	die1->display( d1 );
	die2->display( d2 );

	if( modds ){
		vector<Bet> bets=engine->bets();
		for( vector<Bet>::iterator iter=bets.begin(); iter!=bets.end(); iter++ ){
			Bet b=*iter;
			
			if( b.type==Bet::NUMBER || b.type==Bet::NONUMBER ){
				if( TopRow::isValid( b.number ) ){
					int addodds=player->oddsFor( b );
					Bet myb=engine->odds( addodds, b.number, ( b.type==Bet::NONUMBER ) );
					if( myb.ok() ){
						win( -addodds );
						refreshBet( myb );
					}
				}
			}
		}
	}
}

void TableFrame::win( int payout ){
	player->addcash( payout );
	if( payout<0 ){
		allbets-=payout;
		emit totalBets( allbets );
	}
}

void TableFrame::maxodds( bool b ){ modds=b; }
void TableFrame::dumbbets( bool b ){ dbets=b; }
int TableFrame::rolls() const { return nrolls; }
void TableFrame::roll(){
	nrolls++;
	engine->roll();
}

void TableFrame::placeBet( const Bet& ){}
void TableFrame::refreshBet( const Bet& b ){
	//cout<<"refreshbet called for "<<b.number<<"o"<<b.odds<<" (type: "<<b.type<<")"<<endl;

	int xx=0;
	int yy=0;
	getBetLocation( b, xx, yy );

	int ysize=20;

	if( b.odds ){
		if( b.type==Bet::PASS || ( b.type==Bet::NUMBER && b.number==button ) ){
			ysize+=40;
		}
		else if( b.type==Bet::NOPASS || 
						 ( b.type==Bet::NONUMBER && b.number==button ) ){
			ysize+=75;
		}
		else ysize+=5;
	}

	//	cout<<"repainting ("<<xx<<","<<yy<<","<<xx+20<<","<<ysize<<")"<<endl;
	repaint( xx, yy, 20, ysize, false );
}



CrapsTip::CrapsTip( KrapsEngine * eng, TableFrame * tf, QToolTipGroup * g ) 
	: QToolTip( tf, g ) {

	table=tf;
	engine=eng;
}

void CrapsTip::maybeTip( const QPoint& p ){
	QRgb pixel=table->rgbUnder( p );
	if( 0==pixel ) return;
	
	int number=0;
	bool dont=false;

	if( TableFrame::FOUR==pixel )       number=4;
	else if( TableFrame::FIVE==pixel )  number=5;
	else if( TableFrame::SIX==pixel )   number=6;
	else if( TableFrame::EIGHT==pixel ) number=8;
	else if( TableFrame::NINE==pixel )  number=9;
	else if( TableFrame::TEN==pixel )   number=10;
	else{
		dont=true;
		if( TableFrame::NOFOUR==pixel )       number=4;
		else if( TableFrame::NOFIVE==pixel )  number=5;
		else if( TableFrame::NOSIX==pixel )   number=6;
		else if( TableFrame::NOEIGHT==pixel ) number=8;
		else if( TableFrame::NONINE==pixel )  number=9;
		else if( TableFrame::NOTEN==pixel )   number=10;
	}

	if( number ){
		// make a rectangle that contains the mouse point
		Bet b=engine->getTopRowBetFor( number, dont );
		if( b.ok() ){
			QString bet=QString( "bet: %1" ).arg( b.bet );
			if( 0<b.odds ) bet+=QString( "\nodds: %1" ).arg( b.odds );
			tip( QRect( 0, 0, p.x()+1, p.y()+1 ), bet );
		}
	}

}

#include "tableframe.moc"
