
#ifndef TABLEFRAME
#define TABLEFRAME

#include "bet.h"

#include <qtooltip.h>
#include <qframe.h>
#include <qcolor.h>

#include <vector>
using namespace std;

class QImage;
class QPixmap;
class QPainter;
class CrapsTip;
class QMouseEvent;
class KrapsEngine;
class DieDisplay;
class CashDisplay;
class Player;

class TableFrame : public QFrame {
	Q_OBJECT
		public:
	TableFrame( KrapsEngine& e, Player& p, QWidget * =0, const char * =0 );
	virtual ~TableFrame();

	static const QRgb PASS, NOPASS, FIELD, BIG6, BIG8, COME, NOCOME, PASSODDS;
	static const QRgb FOUR, PFOUR, FIVE, PFIVE, SIX, PSIX;
	static const QRgb EIGHT, PEIGHT, NINE, PNINE, TEN, PTEN;
	static const QRgb NOFOUR, NOFIVE, NOSIX, NOEIGHT, NONINE, NOTEN;
	static const QRgb ANY7, H2, H12, YO, H3, HORN, ANYC, H4, H6, H8, H10;

	int rolls() const;
	QRgb rgbUnder( const QPoint& ) const ;

 protected:
	QImage * tablemask;
	QPixmap * tablepix, * chippix;
	KrapsEngine * engine;
	Player * player;
	CashDisplay * cash;
	DieDisplay * die1, * die2;
	int button, buttonx, nrolls, allbets;
	bool modds, dbets;
	Bet lastbet;
	CrapsTip * tips;

	void drawContents( QPainter * );
	void mousePressEvent( QMouseEvent * );
	void drawChipAt( QPainter *, int x, int y, const Bet * =0, 
									 bool doodds =false );
	void getBetLocation( const Bet&, int &x, int &y ) const;

public slots:
	void buttonOn( int number );
	void number( int, int );
	void win( int winnings );
	void maxodds( bool );
	void dumbbets( bool );
	void roll();

	void placeBet( const Bet& );
	void refreshBet( const Bet& );

	
 signals:
	void tableBets( int );
	void totalBets( int );
};

class CrapsTip : public QToolTip {
 public:
	CrapsTip( KrapsEngine *, TableFrame *, QToolTipGroup * g =0 );
	void maybeTip( const QPoint& );

 protected:
	TableFrame * table;
	KrapsEngine * engine;
};

#endif
