/***************************************************************************
                          cpreferences.cpp  -  description
                             -------------------
    begin                : Sat Jul 1 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cpreferences.h"

#include <qfiledialog.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <stdlib.h>

CPreferences::CPreferences(QWidget *parent, const char *name) :KDialogBase( IconList, i18n("Configure"), Help|Default|Ok|Cancel,
		Ok, parent, name, true, true  ) {

	KIconLoader icone;
  setHelp( "kslide/index.html", QString::null );
	setIcon(icone.loadIcon("kslide",KIcon::Small));

	setGeneralOptions();
	setImageOptions();
	setGameOptions();
  setFixedSize(350,250);
	
	//Aditionnal init
	setCaption(i18n("Configuration"));
	puzzleImageName="";
	imagepath=KGlobal::dirs()->findResourceDir("data","kslide/kslideui.rc");
	imagepath+="kslide/";
	
	connect(this, SIGNAL(okClicked()), this, SLOT(slotSauver()/*slotOk()*/));
//	connect(this, SIGNAL(user1Clicked()), this, SLOT(slotSauver()));
	connect(this, SIGNAL(cancelClicked()), this, SLOT(slotAnnuler()));
	connect(this, SIGNAL(defaultClicked()), this, SLOT(slotDefault()));
	
	connect(bDefaultImage, SIGNAL(clicked()), this, SLOT(slotLoadDefaultImage()));
	connect(bLoadImage, SIGNAL(clicked()), this, SLOT(slotLoadImage()));
	connect(bRandomImage, SIGNAL(clicked()), this, SLOT(slotLoadRandomImage()));
	
	connect(cbMaxMoveNumber, SIGNAL(toggled(bool)), leMaxMoveNumber, SLOT(setEnabled(bool)));
	connect(cbMaxSolveTime, SIGNAL(toggled(bool)), leMaxSolveTime, SLOT(setEnabled(bool)));
	connect(cbMaxTipNumber, SIGNAL(toggled(bool)), leMaxTipNumber, SLOT(setEnabled(bool)));
	
	connect(cmbBackgroundColor, SIGNAL(activated(int)), this, SLOT(slotWarningMessage(int)));
	litOptions();
	
}

CPreferences::~CPreferences(){
}

/*Read the config file and set the propper values for all widgets*/
void CPreferences::litOptions()
{
  KConfig *config = kapp->config();

  config->setGroup("OPTIONS");
  cbMaxSolveTime->setChecked(config->readBoolEntry("ActivateTimer"));
  cbMaxMoveNumber->setChecked(config->readBoolEntry("ActivateMaxMove"));
  cbMaxTipNumber->setChecked(config->readBoolEntry("ActivateMaxTip"));
  leMaxMoveNumber->setValue(config->readNumEntry("MaxMove"));
  leMaxSolveTime->setValue(config->readNumEntry("Timer"));
  leMaxTipNumber->setValue(config->readNumEntry("MaxTip"));

  cmbBackgroundColor->setCurrentItem(config->readNumEntry("BackgroundColor",0));
  cmbMissingSquareColor->setCurrentItem(config->readNumEntry("MissingSquareColor",0));
  cmbMissingSquareHilightColor->setCurrentItem(config->readNumEntry("MissingSquareHilightColor",0));
  cmbGameLevel->setCurrentItem(config->readNumEntry("GameLevel",2));
}

/*Save those options*/
void CPreferences::Sauver()
{
  KConfig *config = kapp->config();


  config->setGroup("OPTIONS");
  config->writeEntry("ActivateTimer",cbMaxSolveTime->isChecked());
  config->writeEntry("ActivateMaxMove",cbMaxMoveNumber->isChecked());
  config->writeEntry("ActivateMaxTip",cbMaxTipNumber->isChecked());

  if(cbMaxMoveNumber->isChecked())
		config->writeEntry("MaxMove",leMaxMoveNumber->value());
  if(cbMaxSolveTime->isChecked())
	  config->writeEntry("Timer",leMaxSolveTime->value());
  if(cbMaxTipNumber->isChecked())
	  config->writeEntry("MaxTip",leMaxTipNumber->value());

  config->writeEntry("BackgroundColor",cmbBackgroundColor->currentItem());
  config->writeEntry("MissingSquareColor",cmbMissingSquareColor->currentItem());
  config->writeEntry("MissingSquareHilightColor",cmbMissingSquareHilightColor->currentItem());
  config->writeEntry("GameLevel",cmbGameLevel->currentItem());
}


/** close the dialog box and use the changes */
void CPreferences::slotOk(){
	accept();
}

/** Save the changes */
void CPreferences::slotSauver(){
	Sauver();
	slotOk();
}

/** close the dialog box, and forget the changes */
void CPreferences::slotAnnuler(){
	reject();
}

/** set all the widgets for gzip options */
void CPreferences::setGeneralOptions(){
	QLabel *label;

  QFrame *page = addPage( i18n("Appearance"), i18n("Skin options"),
			  BarIcon("colorize", KIcon::SizeMedium ) );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QGridLayout *gbox = new QGridLayout( 5, 2 );
  topLayout->addLayout( gbox );


  label = new QLabel( i18n("Background color"), page);
  gbox->addWidget( label, 0, 0 );

  cmbBackgroundColor = new QComboBox( false, page );
  cmbBackgroundColor->insertItem(i18n("Wood"));
  cmbBackgroundColor->insertItem(i18n("Grey"));
  cmbBackgroundColor->insertItem(i18n("Pink"));
  cmbBackgroundColor->setCurrentItem(0);
  gbox->addWidget( cmbBackgroundColor, 1, 0 );

  label = new QLabel( i18n("Missing square color"), page);
  gbox->addWidget( label, 0, 1 );

  cmbMissingSquareColor = new QComboBox( false, page );
  cmbMissingSquareColor->insertItem(i18n("Black"));
  cmbMissingSquareColor->insertItem(i18n("Grey"));
  cmbMissingSquareColor->setCurrentItem(0);
  gbox->addWidget( cmbMissingSquareColor, 1, 1 );

  label = new QLabel( i18n("Missing square higlight color"), page);
  gbox->addWidget( label, 0, 2 );

  cmbMissingSquareHilightColor = new QComboBox( false, page );
  cmbMissingSquareHilightColor->insertItem(i18n("Black"));
  cmbMissingSquareHilightColor->insertItem(i18n("Grey"));
  cmbMissingSquareHilightColor->setCurrentItem(0);
  gbox->addWidget( cmbMissingSquareHilightColor, 1, 2 );

  topLayout->addStretch(10);
}

/** set the widgets for the TAR tab */
void CPreferences::setImageOptions(){
  QFrame *page = addPage( i18n("Image"), i18n("Image options"),
			  BarIcon("folder", KIcon::SizeMedium ) );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QGridLayout *gbox = new QGridLayout( 3, 0 );
  topLayout->addLayout( gbox );

  bLoadImage= new QPushButton(i18n("load an image"), page,"NoName");
  gbox->addWidget( bLoadImage, 0, 0 );

  bDefaultImage= new QPushButton(i18n("load default image"), page,"NoName");
  gbox->addWidget( bDefaultImage, 1, 0 );

  bRandomImage= new QPushButton(i18n("load random image"), page,"NoName");
  gbox->addWidget(bRandomImage , 2, 0 );

  topLayout->addStretch(10);
}

/** set the widgets for default directories */
void CPreferences::setGameOptions(){
  QFrame *page = addPage( i18n("Game"), i18n("Game options"),
			  BarIcon("kcmsystem", KIcon::SizeMedium ) );

	QLabel *label;
  QGridLayout *gbox = new QGridLayout( page, 4, 4 );

  cbMaxTipNumber = new QCheckBox( i18n("Max tip number"), page);
  gbox->addWidget(cbMaxTipNumber , 0, 0 );

  leMaxTipNumber= new QSpinBox(page);
  leMaxTipNumber->setEnabled(false);
  gbox->addWidget(leMaxTipNumber,0 ,1 );

  cbMaxMoveNumber = new QCheckBox( i18n("Max move number"), page);
  gbox->addWidget( cbMaxMoveNumber, 1, 0 );

  leMaxMoveNumber= new QSpinBox(page);
  leMaxMoveNumber->setEnabled(false);
  gbox->addWidget(leMaxMoveNumber,1 ,1 );

  cbMaxSolveTime = new QCheckBox( i18n("Max solve time (in mins)"), page);
  gbox->addWidget( cbMaxSolveTime, 2, 0 );

  leMaxSolveTime= new QSpinBox(page);
  leMaxSolveTime->setEnabled(false);
  gbox->addWidget(leMaxSolveTime,2 ,1 );

  label = new QLabel( i18n("Game level"), page);
  gbox->addWidget( label, 3, 0 );

  cmbGameLevel = new QComboBox( false, page );
  cmbGameLevel->insertItem(i18n("Bayby"));
  cmbGameLevel->insertItem(i18n("Easy"));
  cmbGameLevel->insertItem(i18n("Medium"));
  cmbGameLevel->insertItem(i18n("Hard"));
  cmbGameLevel->setCurrentItem(2);
  gbox->addWidget( cmbGameLevel, 3, 1 );

}

/** set all widgets to default settings */
void CPreferences::slotDefault(){
	cbMaxSolveTime->setChecked(false);
	leMaxSolveTime->setEnabled(false);
	cbMaxMoveNumber->setChecked(false);
	leMaxMoveNumber->setEnabled(false);
	cbMaxTipNumber->setChecked(false);
	leMaxTipNumber->setEnabled(false);	

  cmbBackgroundColor->setCurrentItem(2);
  cmbMissingSquareColor->setCurrentItem(2);
  cmbMissingSquareHilightColor->setCurrentItem(2);
}

void  CPreferences::initDialog(){
  this->resize(370,220);
  this->setFixedSize(370,220);
}

/** Load a default puzzle */
void CPreferences::slotLoadDefaultImage(){
  puzzleImageName="puzzle0.jpg";
	puzzleImageName=imagepath+puzzleImageName;
}


/** Load a random puzzle */
void CPreferences::slotLoadRandomImage(){
//Max number levels here set to 2
	puzzleImageName="puzzle"+QString::number(rand()%2);
	puzzleImageName+=".jpg";
	puzzleImageName=imagepath+puzzleImageName;
}

/** Load a specified puzzle */
void CPreferences::slotLoadImage(){
  puzzleImageName = QFileDialog::getOpenFileName(0, "*.jpg | jpg images\n*.png | png images", this,
    i18n("Load Image..."));
}

/** Get the name of the puzzle's image to be loaded */
QString CPreferences::getLoadImageName(){
	return puzzleImageName;
}

/** return the max moves number */
bool CPreferences::getMaxMovesNumber( int* moves ){
	if(cbMaxMoveNumber->isChecked())
	{
		*moves=leMaxMoveNumber->value();
		return true;
	}
	return false;
}

/** return the max game time */
bool CPreferences::getMaxSolveTime( int* mins ){
	if(cbMaxSolveTime->isChecked())
	{
		*mins=leMaxSolveTime->value();
		return true;
	}
	return false;
}

/** return the max game time */
bool CPreferences::getMaxHintNumber( int* hint ){
	if(cbMaxTipNumber->isChecked())
	{
		*hint=leMaxTipNumber->value();
		return true;
	}
	return false;
}

/** The skin feature is not achieved */
void CPreferences::slotWarningMessage(int){
	KMessageBox::sorry(this, i18n("This function is not yet complete\nYou have to save and restart kslide \nfor changes to take effect."));
}

/** Return the game difficulty option */
int CPreferences::getGameLevel(){
	return cmbGameLevel->currentItem();
}

/** returns the selected skin number (frame0.png...) */
int CPreferences::getTextureNumber(){
  return cmbBackgroundColor->currentItem();
}

/** return the tile texture number (tile0.png...) */
int CPreferences::getMissingSquareTextureNumber(){
  return cmbMissingSquareColor->currentItem();
}

//#include "cpreferences.moc.cpp"
