/***************************************************************************
                          arclengthfunction.h  -  description
                             -------------------
    begin                : Mon Nov 11 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARCLENGTHFUNCTION_H
#define ARCLENGTHFUNCTION_H

#include "mathfunction.h"

class QPainter;
class QPointArray;

/**
  *\author Fungmeista
  *\note This numerically calculates the length of arc.  This means that for non-continuous functions it will not return correct values of arc length
  *      since the length of arc is not defined.
  */
class ArcLengthFunction : public MathFunction
{
	public: 
		ArcLengthFunction(BasicGraph *,int);
		~ArcLengthFunction();

	private:
		void calculate_and_draw(QPainter *);
		void draw_stored(QPainter *);
		QPointArray *pointsStorage;
};

#endif //ARCLENGTHFUNCTION
