/***************************************************************************
                          basicgraph.h  -  description
                             -------------------
    begin                : Thu May 30 2002
    copyright            : (C) 2002 by Fungmeista
    email                : confederacy2@excite.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BASICGRAPH_H
#define BASICGRAPH_H

#include <qwidget.h>

#include <vector>

#include "commongraph.h"
#include "mathfunctionimplementor.h"

#ifdef KDE_APP
class KPrinter;
#else
class QPrinter;
#endif

class QPainter;
class QPixmap;

class Mathfunction;
class GraphEvent;

/**
 * \author Fungmeista
 * \brief Paints basic features for a graph such as grid, axis, scale, and handles converting between
 *  actually pixel coordinates and the desired coordinates considering the scale and origin.
 */

class BasicGraph : public QWidget, public CommonGraph, public MathFunctionImplementor
{
	Q_OBJECT

	public:
		BasicGraph ( QWidget *parent=0, const char *name=0 );
		virtual ~BasicGraph();
		
		/** \return Color of the axis. */
		QColor axisColor() const;             
		
		/** \return Color of the grid. */
		QColor gridColor() const;

		/** \return Color of the background. */
		QColor backgroundColor() const;
		
		/** \return Color of the scale. */
		QColor scaleColor() const;

		#ifdef KDE_APP
		virtual void print(KPrinter *);
		#else
		virtual void print(QPrinter *);
		#endif //KDE_APP

		/** Sets the minimum x bounds. */
		int setXMin(double xMin);

		/** Sets the maximum x bounds. */
		int setXMax(double xMax);

		/** Sets the scale on the x direction.  This is the distance that the grid is spaced in the x direction and the spacing of the x scale. */
		int setXScale(double xScale);

		/** Sets the minimum y bounds. */
		int setYMin(double yMin);

		/** Sets the maximum y bounds. */
		int setYMax(double yMax);

		/** Sets the scale on the x direction.  This is the distance that the grid is spaced in the x direction and the spacing of the x scale. */
		int setYScale(double yScale);

		/** \return Minimum x bounds */
		inline double getXMin() const{return xMin;}

		/** \return Maximum x bounds */
		inline double getXMax() const{return xMax;}

		/** \return Minimum y bounds */
		inline double getYMin() const{return yMin;}

		/** \return Maximum x bounds */
		inline double getYMax() const{return yMax;}

		/** \return Scale on the x direction. */
		inline double getXScale() const{return xScale2;}

		/** \return Scale on the y direction. */
		inline double getYScale() const{return yScale2;}

		/** \return Scale of the radius. */
		inline double getRScale() const{return getXScale();}

		/** \return Scale of the angle. */
		inline double getAScale() const{return getYScale();}

		/** \return Whether of not the axis is turned on. */
		inline bool getAxisState() const{return showAxis;}

		/** \return Whether of not the grid is turned on. */
		inline bool getGridState() const{return showGrid;}

		/** \return Whether of not the labeling of the scale is turned on. */
		inline bool getScaleState() const{return showScale;}

		/** \return Factor of zoom in the x direction which is used in a call to zoomIn() or zoomOut(). */
		int getXZoomFactor() const;

		/** \return Factor of zoom in the y direction which is used in a call to zoomIn() or zoomOut(). */
		int getYZoomFactor() const;

		/** \return The x coordinate of where the active point is over the graph.  This is usually the x coordinate
		  *  of the mouse over the graph.  An exception could be when tracing a function.
		  */
		inline double getMouseX() const{return mouseX;}

		/** \return The x coordinate of where the active point is over the graph.  This is usually the x coordinate
		  *  of the mouse over the graph.  An exception could be when tracing a function.
		  */
		inline double getMouseY() const{return mouseY;}

		inline QPoint getMousePoint() const{return QPoint(toPixelXCoord(mouseX),toPixelYCoord(mouseY));}

		/** Sets the x and y minimum and maximum bounds all in one call.  This is equivalent to calling each seperate
		  * setXMin, setXMax, etc. function except calling this function will only update the graph once.
		  */
		int setRange(double xMin,double xMax,double yMin,double yMax);

		inline virtual void setSnapToGrid(bool b){snapToGrid = b;}
		inline virtual bool isSnapToGrid() const{return snapToGrid;}
		
		virtual void installMathFunctions();
		virtual int execMathFunction( const char * id );

	public slots:
		int setAScale(double d){return setYScale(d);}
		int setRScale(double d){return setXScale(d);}
		void setGrid(bool);
		void setAxis(bool);
		void setGridNum(bool);
		void setScale(bool);
		void setXZoomFactor(int);
		void setYZoomFactor(int);
		void setAxisColor(const QColor &);
		void setGridColor(const QColor &);
		void setBackgroundColor(const QColor &);
		void setScaleColor(const QColor &);
		void zoomIn();
		void zoomOut();
		void setAxisWidth(int);
		void zoomStd();
		void zoomBox();

	signals:
		void dimensionsChanged( const GraphEvent & );
		void activeCoordinateChanged( const QString &, const QString & = QString(), const QString & = QString() );
		void infoMessageReady( const QString & );

	protected:
		friend class MathFunction;

		/** Sets the x-coordinate at which you wish the graph to think the mouse is at to
		  * the value in "x_coordinate".  The second argument can optionally be given and
		  * this is a boolean which overrides the global option of whether or not to snap to the grid.
		  */
		void setMouseX(double x_coordiniate,bool snapToGrid=true);

		/** Sets the y-coordinate at which you wish the graph to think the mouse is at to
		  * the value in "y_coordinate".  The second argument can optionally be given and
		  * this is a boolean which overrides whether the global option to snap to the grid.
		  */
		void setMouseY(double y_coordiniate,bool snapToGrid=true);

		virtual void drawAfterAxis(QPainter *){}            
                
		inline virtual double snapIntervalX() const{return xScale2;}
		inline virtual double snapIntervalY() const{return yScale2;}
		inline virtual double startSnap() const{return 0;}

		virtual void updateCoords();

		void paint(QPainter*);
		void setCoordinateStyle(int i){mode = i;}
		double toGraphXCoord(double) const;
		double toGraphYCoord(double) const;
		int toPixelXCoord(double) const;
		int toPixelYCoord(double) const;
		void updateGraph();
		void emitDimensionsChanged();

		double xMin,xMax,xScale2,yMin,yMax,yScale2,xScale,yScale,mouseX,mouseY;
		int xZoom,yZoom,axisWidth;
		QFont graphFont,scaleFont;
		QPainter *p;
		QPixmap *buffer;

		//events
		void paintEvent (QPaintEvent *);
		void resizeEvent (QResizeEvent *);
		void mouseDoubleClickEvent (QMouseEvent *);
		void mouseMoveEvent(QMouseEvent *);
		void mousePressEvent(QMouseEvent *);
		void mouseReleaseEvent ( QMouseEvent *);

	private:
		bool mouseDown, doingZoomBox, snapToGrid;
		bool showAxis,showGrid,showGridNum,showScale;
		int mode;
		QPoint origin, lastClick;
		double lastClickGraphCoordX,lastClickGraphCoordY;
		QColor _axisColor,_gridColor,_backgroundColor,_scaleColor;
		void drawGrid (QPainter *);
		void drawScale(QPainter *);
		void drawAxis (QPainter *);
};

#endif
