/***************************************************************************
                          expressiongraph.h  -  description
                             -------------------
    begin                : Fri Dec 20 2002
    copyright            : (C) 2002-03 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EXPRESSIONGRAPH_H
#define EXPRESSIONGRAPH_H

#include <vector>

#include "basicgraph.h"
#include "animator.h"

class MathFunction; 
class Expression; 
class FungParser;

typedef std::vector<Expression*> ExpressionPtrVector;

/**
 * \author Fungmeista
 * \brief Subclass this class to create graphs that display graphs of expressions.
 */  
class ExpressionGraph : public BasicGraph, public Animator
{
	Q_OBJECT

	public: 
		ExpressionGraph(QWidget *parent=0, const char *name=0);
		~ExpressionGraph();

		/** Adds and thus graphs the expression.*/
		void addExpression(const Expression &);

		/** Sets the color of the expression at the index given to the color given.*/
		//void setColor(const QColor&,unsigned int);

		/** Removes the expression at the given index */
		void removeExpression(unsigned int index);

		inline unsigned int getCurrentExpressionIndex(){return expressionIndex;}
		inline void setCurrentExpressionIndex(int i){expressionIndex = i;}
		Expression getExpression(unsigned int i) const;
		inline unsigned int functionCount(){return functions.size();}
		
		#ifdef KDE_APP
		virtual void print(KPrinter *);
		#else
		virtual void print(QPrinter *);
		#endif //KDE_APP

		void setAngle(int m){angle = m; reparseAll(); repaint(false);}
		int getAngle() const{return angle;}

		/** \return Whether or not tracing is active. */
		inline bool isTracing() const{return doTrace;}

		/** \return Whether or not the graph is connecting points calculated for the value of the function.  */
		inline bool isDrawConnected() const{return drawConnected;}

		void exportAsImage(const QString& file,const QString& fileType);
                void onlyShowActive(bool b){only_show_active = b;}
		
	public slots:
		void nextExpression();
		void prevExpression();
		inline void setDrawConnected(bool b){drawConnected = b; repaint(false);}
		void setShowCurrentExpression(bool state);
		void setTrace(bool);
		
		void slotNextFrame(){nextFrame();}
		
	signals:
		void animationValueChanged(double);

	protected:
		friend class MathFunction;

		//virtual int callSetXYForTrace(const double, const double, double *, double *);
		virtual int setXYForTrace(const double, const double, double *, double *, Expression &){return 0;}
		//virtual void callDrawExpression(Expression &, QPainter *painter);
		virtual void drawExpression(QPainter *, Expression & expression) = 0;
		void drawExpressionAt(QPainter *painter, int i);
		virtual void putUndefinedMessage(double x, double y);
		virtual unsigned int var_count(){return 1;}
                virtual void drawAfterAxis(QPainter *);
		
		/** Returns a list of independent variables for the expression which, when there are more
		  * than one, are seperated by commas.
		  */
		virtual const char * independent_vars() = 0;
		/** Returns the dependent variable.  The argument 'i' is used to get each dependent variable
		  * if there are more than one ( i.e. parametric graph ).
		  */
		virtual const char * dependent_var(int i=0) = 0;

		inline virtual double traceDepX(double d){return d;}                          
		inline virtual double traceDepY(double d){return d;}

		void reparseAll();

		/** Returns a pointer to a FungParser object which has the current expression parsed.
		  * This is allocated using 'new' and therefore should be deleted manually by the user.
		  */
		FungParser * getParsedCurrentExpression(int i=0);

		/** Returns a pointer to a FungParser object which has the expression at the given index parsed.
		  * This is allocated using 'new' and therefore should be deleted manually by the user.
		  */
		//FungParser * getParsedExpression( int index, int i = 0 )
		int parseExpression( std::string & expression, FungParser *fp, int i=0);

		bool isValidExpression(const Expression &, std::string *errorMsg = 0);

		//events
		void paintEvent(QPaintEvent*);
		void mouseMoveEvent(QMouseEvent *);
		
		virtual void nextFrameReady();

	private:
		bool doTrace;
		bool drawConnected;
		unsigned int expressionIndex;
		int functionWidth;
		int angle;
		bool only_show_active;

		ExpressionPtrVector functions;

		/** Goes through all expressions, parses them, and then a subclass is responsible for
		  * drawing each parsed expression by implementing drawExpression(QPainter*,FungParser&).
		  * Also, if the expression cannot be drawn with a single parsed expression, a subclass may
		  * implement callDrawExpression(), which will parse all the expressions and then call 
		  * drawExpression(QPainter*,FungParser&,FungParser&,...) or whatever function the subclass
		  * has provided to draw a function.
		  */
		void drawExpressions(QPainter*);
};

#endif
