/***************************************************************************
                          functiongraph.h  -  description
                             -------------------
    begin                : Sat May 25 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami442@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FUNCTIONGRAPH_H
#define FUNCTIONGRAPH_H

#include "expressiongraph.h"

class FungParser;

/**
 * \author Fungmeista
 * \brief A class for plotting/graphing explicit two dimensional functions
 */
class FunctionGraph : public ExpressionGraph
{
	Q_OBJECT

	public:
		FunctionGraph ( QWidget *parent=0, const char *name=0 );
		~FunctionGraph();

		/** Execute an installed MathFunction with the given id */
		int execMathFunction( const char * id );
		
		virtual void installMathFunctions();

		virtual inline int getGraphType() const{return FUNCTIONGRAPH;}

	protected:
		virtual const char * independent_vars(){return "x";}
		virtual const char * dependent_var(int=0){return "y";}
		virtual void drawExpression(QPainter *painter, Expression &);
		virtual int setXYForTrace(const double, const double, double *, double *, Expression &);
};

#endif //FUNCTIONGRAPH_H
