/***************************************************************************
                          glbasicgraph.h  -  description
                             -------------------
    begin                : Mon Sep 30 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef GLBASICGRAPH_H
#define GLBASICGRAPH_H

#include <qgl.h>

#include "commongraph.h"

class QTimer;

#ifdef KDE_APP
class KPrinter;
#else
class QPrinter;
#endif

class GLGraphEvent;

/**
 * \author Fungmeista                                                               
 * \brief Handles various OpenGL properties such as lighting, OpenGL events, rotation, axis, and scale.  Currently this class is in alpha stage.
 */
class GLBasicGraph : public QGLWidget, public CommonGraph
{
	Q_OBJECT

	public:
		GLBasicGraph( QWidget *parent=0, const char *name=0 );
		virtual ~GLBasicGraph();

		int setDimension(GLfloat xMin, GLfloat xMax, GLfloat yMin, GLfloat yMax, GLfloat zMin, GLfloat zMax);
		int setXMin(double);
		int setXMax(double);
		int setYMin(double);
		int setYMax(double);
		int setZMin(double);
		int setZMax(double);
		int setXMinView(double);
		int setXMaxView(double);
		int setYMinView(double);
		int setYMaxView(double);
		int setZMinView(double);
		int setZMaxView(double);
		
		void setPolarEye(double);
		void setAzimuthalEye(double);
		GLfloat getXMin() const{return xMin;}
		GLfloat getXMax() const{return xMax;}
		GLfloat getYMin() const{return yMin;}
		GLfloat getYMax() const{return yMax;}
		GLfloat getZMin() const{return zMin;}
		GLfloat getZMax() const{return zMax;}
		GLfloat getXMinView() const{return xMinView;}
		GLfloat getXMaxView() const{return xMaxView;}
		GLfloat getYMinView() const{return yMinView;}
		GLfloat getYMaxView() const{return yMaxView;}
		GLfloat getZMinView() const{return zMinView;}
		GLfloat getZMaxView() const{return zMaxView;}
		GLfloat getZEye() const{return zRot;}
		GLfloat getXEye() const{return xRot;}

		QColor axisColor() const{return _axisColor;}
		QColor backgroundColor() const{return _backgroundColor;}
		QColor scaleColor() const{return _scaleColor;}

		void setAxisColor(const QColor &c){_axisColor = c; updateGL();}
		void setBackgroundColor(const QColor &c){_backgroundColor = c; qglClearColor(_backgroundColor); updateGL();}
		void setScaleColor(const QColor &c){_scaleColor = c; updateGL();}

		void setAxis(bool b){showAxis = b; updateGL();}
		void setScale(bool b){showScale = b; updateGL();}
		bool getAxisState() const{return showAxis;}
		bool getScaleState() const{return showScale;}

		int getXZoomFactor() const{return xZoom;}
		int getYZoomFactor() const{return yZoom;}
		void setXZoomFactor(int i){xZoom = i;}
		void setYZoomFactor(int i){yZoom = i;}

		void exportAsImage(const QString &,const QString &);

		#ifdef KDE_APP
		virtual void print(KPrinter *);
		#else
		virtual void print(QPrinter *);
		#endif //KDE_APP

		void autoRotateX(bool);
		void autoRotateY(bool);
		void autoRotateZ(bool);
		
		bool isAutoRotatingX() const{ return rotating_x;}
		bool isAutoRotatingY() const{ return rotating_y;}
		bool isAutoRotatingZ() const{ return rotating_z;}
		
		/** \return The x coordinate of where the active point is over the graph.  This is usually the x coordinate
		  *  of the mouse over the graph.  An exception could be when tracing a function.
		  */
		inline double getMouseX() const{return mouseX;}

		/** \return The x coordinate of where the active point is over the graph.  This is usually the x coordinate
		  *  of the mouse over the graph.  An exception could be when tracing a function.
		  */
		inline double getMouseY() const{return mouseY;}

		inline virtual void setSnapToGrid(bool b){snapToGrid = b;}
		inline virtual bool isSnapToGrid() const{return snapToGrid;}

	public slots:
		void zoomIn();
		void zoomOut();
		void zoomStd();
		
	signals:
		void graphRotated( const GLGraphEvent & );
		void dimensionsChanged( const GLGraphEvent & );
		void activeCoordinateChanged( const QString &, const QString &, const QString & );
		void infoMessageReady( const QString & );
		void rotateCanceled();

	protected:
		void initializeGL();
		void resizeGL( int w, int h );
		void paintGL();

		void mousePressEvent(QMouseEvent *);
		void mouseMoveEvent(QMouseEvent *);
		void mouseReleaseEvent(QMouseEvent *);

		void emitGraphRotated();
		void emitDimensionsChanged();

		void drawText(GLfloat x, GLfloat y, GLfloat z, const char * s);

		void updateOrtho();
		void updateView();
		virtual void orthoChanged(){}

		double toGraphXCoord(double);
		double toGraphYCoord(double);

		/** Sets the x-coordinate at which you wish the graph to think the mouse is at to
		  * the value in "x_coordinate".  The second argument can optionally be given and
		  * this is a boolean which overrides the global option of whether or not to snap to the grid.
		  */
		void setMouseX(double x_coordiniate,bool snapToGrid=true);

		/** Sets the y-coordinate at which you wish the graph to think the mouse is at to
		  * the value in "y_coordinate".  The second argument can optionally be given and
		  * this is a boolean which overrides whether the global option to snap to the grid.
		  */
		void setMouseY(double y_coordiniate,bool snapToGrid=true);

		virtual double snapIntervalX() const = 0;
		virtual double snapIntervalY() const = 0;
		inline virtual double startSnap() const{return 0;}

		GLfloat _height, _width;

	private:
		void drawAxis();
		//void drawCage();

		void drawLetterMinus(double pos_x, double pos_y, double pos_z, double width);
		void drawLetterPlus(double pos_x, double pos_y, double pos_z, double height, double width);
		void drawLetterX(double pos_x, double pos_y, double pos_z, double height, double width);
		void drawLetterY(double pos_x, double pos_y, double pos_z, double height, double width);
		void drawLetterZ(double pos_x, double pos_y, double pos_z, double height, double width);

		bool showAxis,showScale;
		GLfloat xMin,xMax,yMin,yMax,zMin,zMax;
		GLfloat xMinView, xMaxView, yMinView, yMaxView, zMinView, zMaxView;
		GLfloat xRot,yRot,zRot;
		QPoint *lastClick,*origin;
		double xScale,yScale, mouseX, mouseY;
		bool mouseDown, snapToGrid;
		QColor _scaleColor,_axisColor,_backgroundColor;
		int xZoom,yZoom,zZoom;
		
		QTimer *rotate_timer;
		bool rotating_z, rotating_y, rotating_x;
		int rotate_speed;
		
	private slots:
		void autoRotateStep();
};

#endif // GLBASICGRAPH_H
