/***************************************************************************
                          glgraphevent.h  -  description
                             -------------------
    begin                : Tue Oct 22 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLGRAPHEVENT_H
#define GLGRAPHEVENT_H

/**
 * \author Fungmeista
 * \brief Holds information of a 3-D graph that changes when a graph event is emitted.
 */
class GLGraphEvent
{ 
	public: 
		GLGraphEvent(float xRot, float zRot){this->xRot = xRot; this->zRot = zRot;}
		GLGraphEvent(float xMin, float xMax,float yMin,float yMax,float zMin,float zMax){_xMin = xMin; _xMax = xMax; _yMin = yMin; _yMax = yMax; _zMin = zMin; _zMax = zMax;}
		~GLGraphEvent(){}
		float polarEye() const {return xRot;}
		float azimuthalEye() const {return zRot;}
		float xMin() const {return _xMin;}
		float xMax() const {return _xMax;}
		float yMin() const {return _yMin;}
		float yMax() const {return _yMax;}
		float zMin() const {return _zMin;}
		float zMax() const {return _zMax;}

	private:
		float xRot, zRot, _xMin, _xMax, _yMin, _yMax, _zMin, _zMax;
};

#endif //GLGRAPHEVENT_H
