/***************************************************************************
                          parametricgraph.h  -  description
                             -------------------
    begin                : Sun May 26 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PARAMETRICGRAPH_H
#define PARAMETRICGRAPH_H

#include "expressiongraph.h"

/**
 * \author Fungmeista
 * \brief A class for plotting/graphing implicit parametric expressions.  Graphs how the independent variable "t"
 *  affects the independent variables "x" and "y".
 */
class ParametricGraph : public ExpressionGraph
{
	Q_OBJECT

	public:
		ParametricGraph(QWidget *parent=0, const char *name=0);
		~ParametricGraph();

		int setTMin(double);
		int setTMax(double);
		int setTStep(double);
		inline double getTStep() const{return tStep;}
		inline double getTMin() const{return tMin;}
		inline double getTMax() const{return tMax;}
		
		virtual void installMathFunctions();
		virtual int execMathFunction( const char * );

		virtual inline int getGraphType() const{return PARAMETRICGRAPH;}

	protected:
		virtual void updateCoords();
		inline virtual const char * independent_vars(){return "t";}
		inline virtual const char * dependent_var(int i){return (i == X_VAR) ? "x" : "y";}
		
		virtual int setXYForTrace(const double, const double, double *, double *, Expression &);
		virtual void putUndefinedMessage(double x, double y);
		//virtual void callDrawExpression(Expression &, QPainter *painter);
		virtual void drawExpression(QPainter*, Expression &);
		inline virtual unsigned int var_count(){return 2;}
		inline virtual double snapIntervalX(){return (isTracing()) ? tStep : getXScale();}
		inline virtual double startSnap(){return (isTracing()) ? tMin : 0;}
		inline virtual double traceDepX(double x){return (x-getXMin())/((getXMax()-getXMin())/(tMax-tMin))+tMin;}
		
		virtual void sendCustomClick(QMouseEvent *, MathFunction *, double, double);

	private:
		double tMin,tMax,tStep;

		static const int X_VAR = 0;
		static const int Y_VAR = 1;

		double t_trace;
};

#endif
