/***************************************************************************
                          plotmodule.h  -  description
                             -------------------
    begin                : Sun May 11 2003
    copyright            : (C) 2003 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLOTMODULE_H
#define PLOTMODULE_H

#include "statplotgraph.h"

#include <string>

class QColor;
class QPainter;

/**
 * \author Fungmeista
 * \brief A base class for a Stat Plot's plot modes
 */
class PlotModule
{
	public: 
		/** Pass the PlotModule constructor whether or not the graph is
		  * visible and its color
		  */
		PlotModule( bool, const QColor& );

		/** Draw the plot onto the given QPainter.  The given parameters
		  * may or may not be necessary to draw this.
		  */
		virtual void drawPlot( QPainter *p, int *, StatPlotGraph *graph, double xScale, double yScale ) = 0;

		/** Set where the pointer should be for tracing.  The given x and y integers
		  * are where the mouse is hovering over.  Set where the x and y coordinates
		  * of the mouse should be for tracing in the variables new_x and new_y.
		  */
		virtual void trace( double x, double y, double *new_x, double *new_y ) = 0;

		/** This returns a string that will be displayed to the user.
		  * x and y are the current coordinates of the mouse.
		  */
		virtual std::string updateCoords( double x, double y ) = 0;

		/** Set xmin, xmax, ymin, and ymax to the values the graph should have
		  * in order to zoom into the plot.
		  */
		virtual void zoomStat( double *xmin, double *xmax, double *ymin, double *ymax ) = 0;

		/** Hides or shows this plot */
		void setVisible(bool show){_show = show;}

		/** Whether or not the graph is being shown */
		bool show() const{return _show;}

		/** The color of this plot */
		QColor color() const{return _color;}

	protected:
		int toPixelXCoord( StatPlotGraph *s, double d ){return s->toPixelXCoord(d);}
		int toPixelYCoord( StatPlotGraph *s, double d ){return s->toPixelYCoord(d);}

	private:
		bool _show;
		QColor _color;
};

#endif
