/***************************************************************************
                          polarcoord.h  -  description
                             -------------------
    begin                : Sun May 26 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POLARCOORD_H
#define POLARCOORD_H

#define PI 3.141592653589

class RectCoord;

/**
 * \author Fungmeista
 * \brief A class for storing a polar coordinate and can convert it into other coordinates.
 */
class PolarCoord
{
	public:
		static const unsigned int RADIANS = 0;
		static const unsigned int DEGREES = 1;

		PolarCoord(double radius=0,double angle=0,int angleMode=RADIANS, bool bearing=false);
		RectCoord toRectangular();
		double x() const;
		double y() const;
		inline void setAngleMode(const unsigned int m){angleMode = m;}
		inline double getAngle(){return angle;}
		inline double getRadius(){return radius;}
		inline void setBearingMode(bool m){bearingMode = m;}

	private:
		double radius;
		double angle;
		unsigned int angleMode;
		bool bearingMode;
};

#endif //PolarCoord

