/***************************************************************************
                          polargraph.h  -  description
                             -------------------
    begin                : Thu May 30 2002
    copyright            : (C) 2002 by Fungmeista
    email                : confederacy2@excite.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POLARGRAPH_H
#define POLARGRAPH_H

#include "expressiongraph.h"

/**
 * \author Fungmeista
 * \brief A class for plotting/graphing explicit polar expressions.  Graphs the radius with respect to the angle.
 */
class PolarGraph : public ExpressionGraph
{
	Q_OBJECT

	public: 
		PolarGraph(QWidget *parent=0, const char *name=0);

		int setTMin(double);
		int setTMax(double);
		int setTStep(double);
		double getTMin(){return tMin;}
		double getTStep(){return tStep;}
		double getTMax(){return tMax;}

		virtual int getGraphType() const{return POLARGRAPH;}

	protected:
		inline virtual double snapIntervalX(){return (isTracing()) ? tStep : getXScale();}
		inline virtual double startSnap(){return (isTracing()) ? tMin : 0;}

		virtual void updateCoords();

		virtual void drawExpression(QPainter*,Expression &);
		virtual const char * independent_vars(){return "t";}
		virtual const char * dependent_var(int=0){return "r";}
		virtual int setXYForTrace(const double, const double, double *, double *, Expression &);

		inline virtual double traceDepX(double x){return (x-getXMin())/((getXMax()-getXMin())/(tMax-tMin))+tMin;}

	private:
		double tMin,tMax,tStep,t_trace;
};

#endif
