/***************************************************************************
                          scatterplot.h  -  description
                             -------------------
    begin                : Sun May 11 2003
    copyright            : (C) 2003 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCATTERPLOT_H
#define SCATTERPLOT_H

#include "plotmodule.h"

#include <vector>

/**
 * \author Fungmeista
 * \brief A base class for a Stat Plot's plot modes
 */
class ScatterPlot : public PlotModule
{
	public: 
		ScatterPlot(std::vector<double> & xlist, std::vector<double> & ylist, bool show, const QColor & color = QColor());
		virtual ~ScatterPlot(){}
		//bool operator==(const ScatterPlot &);

		virtual void drawPlot( QPainter *, int *, StatPlotGraph *graph, double xScale, double yScale );
		virtual void trace( double, double, double *, double * );
		virtual std::string updateCoords( double, double );

		virtual void zoomStat( double *xmin, double *xmax, double *ymin, double *ymax );

	private:
		std::vector<double> _xlist;
		std::vector<double> _ylist;

		static const int SCATTERWIDTH = 5;
		static const int SCATTERHEIGHT = 5;

};

#endif
