/***************************************************************************
                          sphericalcoord.h  -  description
                             -------------------
    begin                : Sat Nov 30 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPHERICALCOORD_H
#define SPHERICALCOORD_H

/**
  *@author Fungmeista
  */

class Cartesian3DCoord;

/** A coordinate in a coordinate system with an azimuthal, polar, and radial.
  *
  */    
class SphericalCoord
{
	public: 
		SphericalCoord(double azimuthal, double polar, double radial);

		/** Returns coordinates on a 3-dimensional cartesian coordinate system.
		  *  x = radial * cos(azimuthal) * sin(polar) <br>
		  *  y = radial * sin(azimuthal) * sin(polar) <br>
		  *  z = radial * cos(polar) <br>
		  */
		Cartesian3DCoord toCartesianCoord();

	private:
		double azimuthal, polar, radial;
};

#endif
