/***************************************************************************
                          statinfo.h  -  description
                             -------------------
    begin                : Sun Jun 2 2002
    copyright            : (C) 2002 by Fungmeista
    email                : confederacy2@excite.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATINFO_H
#define STATINFO_H

#include <vector>

/**
 * \author Fungmeista
 * \brief Class with several static functions for calculating various statistical information.
 * This class calculates this information assuming that the given vector has been sorted with
 * elements ordered from least to greatest.
 */  
class StatInfo
{
	public:
		StatInfo(){}
		~StatInfo(){}
		static int dcompare(const void * a, const void * b);
		static double mean(std::vector<double> & xList);
		static int items(std::vector<double> & xList);
		static double median(std::vector<double> & xList);
		static double mode(std::vector<double> & xList);
		static double range(std::vector<double> & xList);
		static double min(std::vector<double> & xList);
		static double max(std::vector<double> & xList);
		static double first_quartile(std::vector<double> & xList);
		static double third_quartile(std::vector<double> & xList);
		static double standard_dev(std::vector<double> & xList);
		static double sum(std::vector<double> & xList);
		static double median_fit_line(std::vector<double> & xList, std::vector<double> & yList);
		static double correlation(std::vector<double> & xList, std::vector<double> & yList);
		static double bigger(double,double);
		static double smaller(double,double);
		static int frequency(std::vector<double> & list, double begin, double end);
};
#endif
