/***************************************************************************
                          statplotgraph.h  -  description
                             -------------------
    begin                : Sun Jun 2 2002 -- redone : Fri Oct 11 2002
    copyright            : (C) 2002-03 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATPLOTGRAPH_H
#define STATPLOTGRAPH_H

#include <vector>

#include "basicgraph.h"

class PlotModule;

/**
 * \author Fungmeista
 * \brief Plot several different statistical graphs in two dimensions.  These include box-and-whisker plots, frequency distribution,
 *  and scatter plots.
 */
class StatPlotGraph : public BasicGraph
{
	Q_OBJECT
	public: 
		StatPlotGraph(QWidget *parent=0, const char *name=0);
		~StatPlotGraph();
		static const unsigned int ERROR_EMPTY_XLIST = 0;
		static const unsigned int ERROR_EMPTY_YLIST = 1;

		inline unsigned int getCurrentPlotIndex() const{return plotIndex;}
		
		#ifdef KDE_APP
		virtual void print(KPrinter *);
		#else
		virtual void print(QPrinter *);
		#endif //KDE_APP

		void exportAsImage(const QString&,const QString&);

	public slots:
		void nextPlot();
		void prevPlot();
		void zoomStat();
		void setTrace(bool b){doTrace = b;}
		bool isTracing() const{return doTrace;}
		virtual inline int getGraphType() const{return STATGRAPH;}
		void addPlot(unsigned int index, PlotModule *);
		void removePlot(unsigned int index);
		inline void setActivePlot(unsigned int plot){plotIndex = plot; repaint(false);}
		void setShowCurrentPlot(bool show);
		QColor getColor(unsigned int i) const;

	protected:
		friend class PlotModule;
	
		void updateCoords();

		//events
		void paintEvent(QPaintEvent*);
		void mouseMoveEvent(QMouseEvent *m);

	private:
		unsigned int plotIndex;

		std::vector<PlotModule*> plots;
		void drawPlots(QPainter*);
		bool doTrace;
};

#endif
