/***************************************************************************
                          whiskerplot.h  -  description
                             -------------------
    begin                : Sun May 11 2003
    copyright            : (C) 2003 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WHISKERPLOT_H
#define WHISKERPLOT_H

#include "plotmodule.h"

#include <vector>

#include <qcolor.h>

/**
 * \author Fungmeista
 * \brief WhiskerPlot for creating box-and-whisker plots
 */
class WhiskerPlot : public PlotModule
{
	public: 
		WhiskerPlot(std::vector<double> & xlist, bool show, const QColor & color);
		virtual ~WhiskerPlot(){}

		virtual void drawPlot( QPainter *, int *, StatPlotGraph *graph, double xScale, double yScale );
		virtual void trace( double, double, double *, double * );
		virtual std::string updateCoords( double, double );

		virtual void zoomStat( double *xmin, double *xmax, double *ymin, double *ymax );

	private:
		double _min;
		double _max;
		double _median;
		double _first_quartile;
		double _third_quartile;

		int _vertical;

		std::vector<double> _xlist;

		static const int boxAndWhiskerHeight = 2;

};

#endif
