/*
                 Image Viewer Compile Time Configuration
 */

#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* #define PROG_LANGUAGE_GERMAN		4 */
/* #define PROG_LANGUAGE_ITALIAN	5 */
/* #define PROG_LANGUAGE_DUTCH		6 */
/* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* #define PROG_LANGUAGE_PORTUGUESE	8 */
/* #define PROG_LANGUAGE_POLISH		9 */


/*
 *	Program Name:
 */
#define PROG_NAME			"IV"
#define PROG_NAME_FULL			"Image Viewer"

/*
 *	Program Version:
 */
#define PROG_VERSION			"2.2.1"
#define PROG_VERSION_MAJOR		2
#define PROG_VERSION_MINOR		2
#define PROG_VERSION_RELEASE		1

/*
 *	Program URL:
 */
#define PROG_URL			"http://wolfpack.twu.net/IV/"

/*
 *	Copyright Message:
 */
#define PROG_COPYRIGHT			"\
Copyright (C) 2001-2007 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"

/*
 *	Program Usage Message:
 */
#define PROG_USAGE			"\
Usage: iv [file(s)...] [options] [GUI_options]\n\
\n\
    The [file(s)...] specifies the paths to the file(s) to open at\n\
    startup.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --frame=<n>             Display frame index <n> at startup\n\
                                (disables playing at startup).\n\
        -f=<n>                  Same as --frame.\n\
        -r                      Do not resize window on load.\n\
        -m                      Disable tooltips.\n\
        -t                      Hide tool bar.\n\
        -v                      Hide values.\n\
        -s                      Hide progress bar.\n\
        -i                      Show image on window manager icon.\n\
        -q=<n>                  Set resolution quality to <n>, where\n\
                                <n> can be 0 to 2 (2 being best/slowest).\n\
	-bg=<color>		Sets the background color to <color>.\n\
        -b=<n>                  Set Imlib fallback code to <n>.\n\
\n\
        --screenshot            Map the Screenshot Dialog at startup\n\
                                (may not be combined with opening images\n\
                                at startup).\n\
        -g                      Same as --screenshot.\n\
\n\
        --fullscreen=<file>     Displays the image <file> fullscreen,\n\
                                waits for user response, and then exits.\n\
        -fs=<file>              Same as --fullscreen.\n\
\n\
        --root-centered=<file>  Displays the image <file> on the desktop\n\
                                centered and then exits.\n\
        --root-tofit=<file>     Displays the image <file> on the desktop\n\
                                to fit and then exits.\n\
        --root-tocover=<file>   Displays the image <file> on the desktop\n\
                                to cover and then exits.\n\
        --root-tiled=<file>     Displays the image <file> on the desktop\n\
                                tiled and then exits.\n\
\n\
        --print=<file>          Map the Print Dialog to query the user\n\
                                to print the image <file> and then exit.\n\
\n\
        --auto_hide_iv_nonimage Hide the Image Viewer window when a\n\
                                non-image file is opened in the File\n\
                                Viewer.\n\
        -k                      Same as --auto_hide_iv_nonimage.\n\
\n\
        --simple_title          Displays a simple less-graphical title\n\
                                at startup.\n\
\n\
        --help                  Prints this help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    [GUI_options] can be any of the following:\n\
\n\
        --geometry <WxH+X+Y>    Specifies the window's geometry.\n\
        --font <font>           Specifies the font to be used for\n\
                                value labels.\n\
        --name <name>           Specifies the Window Manager window name.\n\
        --class <class>         Specifies the Window Manager window class.\n\
        --title <title>         Specifies the window's title.\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       General error.\n\
        2       Invalid value, corrupt file, or no such file.\n\
        3       Systems error (out of memory or out of device space).\n\
        4       User aborted.\n\
\n"


/*
 *	Default Save Option Values:
 */
#define GIF_DEF_INTERLACED		FALSE
#define GIF_DEF_FORMAT			2	/* 0 = B&W
						 * 1 = Greyscale
						 * 2 = Color */
#define GIF_DEF_TRANSPARENCY		TRUE
#define GIF_DEF_LOOPING			TRUE

#define	JPEG_DEF_QUALITY		0.80f	/* 0.0 to 1.0 */
#define JPEG_DEF_IS_COLOR		TRUE

#define PNG_DEF_COMPRESSION		6	/* 0 to 9 */
#define PNG_DEF_FORMAT			4	/* 0 = B&W
						 * 1 = Greyscale
						 * 2 = Greyscale Alpha
						 * 3 = RGB
						 * 4 = RGBA */
#define PNG_DEF_INTERLACED		FALSE

#define TGA_DEF_FORMAT			2	/* 0 = Greyscale
						 * 1 = RGB
						 * 2 = RGBA */

#define XPM_DEF_FORMAT			2	/* 0 = B&W
						 * 1 = Greyscale
						 * 2 = Color */
#define XPM_DEF_MAX_COLORS		256	/* -1 for no limit */
#define XPM_DEF_THRESHOLD		0x80	/* 0x00 to 0xff */


/*
 *	Default Screenshot Values:
 */
#define SCREENSHOT_DEF_DELAY		2000l	/* In milliseconds */
#define SCREENSHOT_DEF_INCLUDE_DECORATIONS	TRUE
#define SCREENSHOT_DEF_HIDE_WINDOWS	FALSE

/*
 *	Default Color Levels Values:
 */
#define COLOR_LEVELS_DEF_ALL_FRAMES	FALSE

/*
 *	Default Add Text Values:
 */
#define ADD_TEXT_DEF_FONT_NAME		"-adobe-helvetica-bold-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define ADD_TEXT_DEF_COLOR		{ 0, 0xffff, 0xffff, 0xffff }	/* GdkColor */
#define ADD_TEXT_DEF_OUTLINE		TRUE
#define ADD_TEXT_DEF_OUTLINE_COLOR	{ 0, 0x0000, 0x0000, 0x0000 }	/* GdkColor */
#define ADD_TEXT_DEF_OPACITY		1.0f	/* 0.0 to 1.0 */
#define ADD_TEXT_DEF_ALL_FRAMES		FALSE


/*
 *	Default Print Values:
 */
#define PRINT_DEF_COMMAND		"/usr/bin/lpr"
#define PRINT_DEF_FILE			"untitled.ps"


/* 
 *      Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER		"BROWSER"
#define ENV_VAR_NAME_DISPLAY		"DISPLAY"
#define ENV_VAR_NAME_HELPBROWSER	"HELPBROWSER"
#define ENV_VAR_NAME_HOME		"HOME"
#define ENV_VAR_NAME_PATH		"PATH"
#define ENV_VAR_NAME_PRINTCMD		"PRINTCMD"
#define ENV_VAR_NAME_PRINT		"PRINT"
#define ENV_VAR_NAME_TMPDIR		"TMPDIR"
#define ENV_VAR_NAME_USER		"USER"
#define ENV_VAR_NAME_USERNAME		"USERNAME"


/*
 *	Cursor Blink Interval (In Milliseconds):
 */
#define CURSOR_BLINK_INT		400l


/*
 *	Widget Names:
 */
#define IV_IMGVIEW_TOPLEVEL_WIDGET_NAME	"iv-imgview"
#define IV_DATAVIEW_TOPLEVEL_WIDGET_NAME	"iv-dataview"
#define IV_DATAVIEW_TEXT_VIEW_WIDGET_NAME	"iv-dataview-text-view"
#define IV_DATAVIEW_HEX_VIEW_WIDGET_NAME	"iv_dataview-hex-view"


/*
 *	Drag & Drop Target Types:
 */
#define DND_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define DND_INFO_TEXT_URI_LIST		1	/* "text/uri-list" */
#define DND_INFO_STRING			2	/* "STRING" */

#define IV_DND_TARGET_FRAME_INDEX	"IV/Frame/Index"
#define IV_DND_INFO_FRAME_INDEX		10


/*
 *	Default Progress Bar Ticks:
 */
#define PROGRESS_BAR_DEF_TICKS		25


/*
 *	Default GtkCList Row Spacing:
 */
#define CLIST_DEF_ROW_SPACING		20


/*
 *	Image File Format Extensions:
 *
 *	With the '.' prefix.
 */
#define FTYPE_EXT_BMP			".bmp"
#define FTYPE_EXT_DCX			".dcx"
#define FTYPE_EXT_FAXG3			".fax"
#define FTYPE_EXT_GBM			".gbm"
#define FTYPE_EXT_GIF			".gif"
#define FTYPE_EXT_GREY			".grey"
#define FTYPE_EXT_HRZ			".hrz"
#define FTYPE_EXT_JPG			".jpg"
#define FTYPE_EXT_JPEG			".jpeg"
#define FTYPE_EXT_MNG			".mng"
#define FTYPE_EXT_MPC			".mpc"
#define FTYPE_EXT_PAT			".pat"
#define FTYPE_EXT_PBM			".pbm"
#define FTYPE_EXT_PCD			".pcd"
#define FTYPE_EXT_PCX			".pcx"
#define FTYPE_EXT_PIC			".pic"
#define FTYPE_EXT_PICT			".pict"
#define FTYPE_EXT_PIX			".pix"
#define FTYPE_EXT_PGM			".pgm"
#define FTYPE_EXT_PNG			".png"
#define FTYPE_EXT_PNM			".pnm"
#define FTYPE_EXT_PPM			".ppm"
#define FTYPE_EXT_PS			".ps"
#define FTYPE_EXT_PS2			".ps2"
#define FTYPE_EXT_PS3			".ps3"
#define FTYPE_EXT_PSD			".psd"
#define FTYPE_EXT_RGB			".rgb"
#define FTYPE_EXT_RGBA			".rgba"
#define FTYPE_EXT_RLE			".rle"
#define FTYPE_EXT_SGI			".sgi"
#define FTYPE_EXT_TGA			".tga"
#define FTYPE_EXT_TARGA			".targa"
#define FTYPE_EXT_TIF			".tif"
#define FTYPE_EXT_TIFF			".tiff"
#define FTYPE_EXT_XBM			".xbm"
#define FTYPE_EXT_XCF			".xcf"
#define FTYPE_EXT_XPM			".xpm"
#define FTYPE_EXT_XWD			".xwd"
#define FTYPE_EXT_WMF			".wmf"

/*
 *	Supported Image File Extensions List:
 */
#define IV_IMAGE_LIST	{					\
	FTYPE_EXT_BMP,		"Windows Bitmap",		\
	FTYPE_EXT_DCX,		"ZSoft MultiPage PaintBrush Image", \
	FTYPE_EXT_FAXG3,	"FAX Group3",			\
	FTYPE_EXT_GBM,		"GBM Image Format",		\
	FTYPE_EXT_GIF,		"Compuserve Graphics Interchange Format", \
	FTYPE_EXT_GREY,		"Raw Greyscale Image",		\
	FTYPE_EXT_HRZ,		"HRZ Image Format",		\
	FTYPE_EXT_JPG,		"JPEG Image",			\
	FTYPE_EXT_MNG,		"MultiImage Portable Network Graphics", \
	FTYPE_EXT_MPC,		"Image Magick Cache",		\
	FTYPE_EXT_PAT,		"PAT Image Format",		\
	FTYPE_EXT_PBM,		"Portable Bitmap",		\
	FTYPE_EXT_PCD,		"Photo CD",			\
	FTYPE_EXT_PCX, 		"ZSoft PaintBrush Image",	\
	FTYPE_EXT_PIC,		"Apple Macintosh QuickDraw",	\
	FTYPE_EXT_PIX,		"Alias/Wavefront RLE",		\
	FTYPE_EXT_PGM,		"PGM Image Format",		\
	FTYPE_EXT_PNG,		"Portable Network Graphics",	\
	FTYPE_EXT_PNM,		"PNM Image Format",		\
	FTYPE_EXT_PPM,		"PPM Image Format",		\
	FTYPE_EXT_PS,		"Adobe ISO PostScript",		\
	FTYPE_EXT_PS2,		"Adobe ISO PostScript 2",	\
	FTYPE_EXT_PS3,		"Adobe ISO PostScript 3",	\
	FTYPE_EXT_PSD,		"Adobe Photoshop Bitmap",	\
	FTYPE_EXT_RLE,		"Utah Run Length Encoded",	\
	FTYPE_EXT_RGB,		"Raw RGB Image",		\
	FTYPE_EXT_RGBA,		"Raw RGBA Image",		\
	FTYPE_EXT_SGI,		"Irix Image",			\
	FTYPE_EXT_TGA,		"Targa Image Format",		\
	FTYPE_EXT_TIF,		"Tempory Image File Format",	\
	FTYPE_EXT_XBM,		"X Bitmap",			\
	FTYPE_EXT_XCF,		"GIMP Image Format",		\
	FTYPE_EXT_XPM,		"X Pixmap",			\
	FTYPE_EXT_XWD,		"X Image",			\
	FTYPE_EXT_WMF,		"Windows Meta File",		\
	NULL,			NULL				\
}

#endif	/* CONFIG_H */
