/*
				     Desktop

	Displaying images on to the desktop (root window).
 */

#ifndef DESKTOP_H
#define DESKTOP_H

#include <gtk/gtk.h>
#include "guiutils.h"


extern void iv_desktop_mesg(
	GdkWindow *root_window, GdkGC *gc,
	GtkStyle *style, GtkJustification justify,
	const gchar *title,
	GdkPixmap *icon_pixmap, GdkBitmap *icon_mask,
	const gchar *s
);

extern void iv_desktop_put_image_centered(
	GdkWindow *root_window,
	gint quality,			/* 0 to 2 */
	const guint8 *data,
	gint width, gint height, gint bpp, gint bpl,
	const guint8 *bg_color
);
extern void iv_desktop_put_image_tofit(
	GdkWindow *root_window,
	gint quality,			/* 0 to 2 */
	const guint8 *data,
	gint width, gint height, gint bpp, gint bpl,
	const guint8 *bg_color
);
extern void iv_desktop_put_image_tocover(
	GdkWindow *root_window,
	gint quality,			/* 0 to 2 */
	const guint8 *data,
	gint width, gint height, gint bpp, gint bpl,
	const guint8 *bg_color
);
extern void iv_desktop_put_image_tiled(
	GdkWindow *root_window,
	gint quality,			/* 0 to 2 */ 
	const guint8 *data,
	gint width, gint height, gint bpp, gint bpl,
	const guint8 *bg_color
);


#endif	/* DESKTOP_H */
