#ifndef IMGIO_H
#define IMGIO_H

#include <sys/types.h>
#if defined(WIN32)
# include "../include/os.h"
#endif


/* Public */

/* Error Messages */
extern const char *ImgLoadGetError(void);
extern const char *ImgWriteGetError(void);

/* Getting Library Versions */
#ifdef HAVE_LIBGIF
extern void ImgGIFVersion(int *major, int *minor, int *release);
#endif
#ifdef HAVE_LIBJPEG
extern void ImgJPEGVersion(int *major, int *minor, int *release);
#endif
#ifdef HAVE_LIBPNG
extern void ImgPNGVersion(int *major, int *minor, int *release);
#endif
#ifdef HAVE_LIBXPM
extern void ImgXPMVersion(int *major, int *minor, int *release);
#endif


#ifdef HAVE_IMLIB
/* Imlib Image Data To RGBA Converter */
extern u_int8_t *ConvertImlibDataToRGBA(
       const u_int8_t *rgb, const u_int8_t *alpha,
	int width, int height,
	int rgb_bpl, int alpha_bpl,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#endif

/* Open Image */
extern int ImgLoadFileRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t ***rgba_list_rtn, unsigned long **delay_list_rtn,
	int *nframes_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	int *x_rtn, int *y_rtn,
	int *base_width_rtn, int *base_height_rtn,
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	)
);

/* Save Image With Imlib */
extern int ImgWriteImlibFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t *rgba,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	const char *comments,	/* May be NULL */
	float quality,		/* 0.0 to 1.0 */
	int save_as_color,	/* True means to save as color */
	u_int8_t def_alpha_value,
	int imlib_fallback,	/* 0 = none or 1 = ImageMajick & NetPBM */
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *      /* RGBA data */
	)
);
#ifdef HAVE_LIBGIF
/* Save Image With libgif */
extern int ImgWriteGIFFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t **rgba, unsigned long *delay_list,
	int nframes,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	const char *comments, 
	int interlaced,		/* 0 or 1 */
	int format,		/* 0 = B&W
				 * 1 = Greyscale
				 * 2 = Color */
	int transparency,	/* 0 or 1 */
	int looping,		/* 0 = no looping, 1 = looping */
	void *client_data,
	int (*progress_cb)( 
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	)
);
#endif
#ifdef HAVE_LIBJPEG
/* Save Image With libjpeg */
int ImgWriteJPEGFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t *rgba,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	int quality,		/* 0 to 100 */
	int format,		/* 0 = Greyscale
				 * 1 = Color */ 
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	)
);
#endif
#ifdef HAVE_LIBPNG
/* Save Image With libpng */
extern int ImgWritePNGFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t *rgba,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	int x, int y,
	int base_width, int base_height,
	const char *creator, const char *title,
	const char *author, const char *comments,
	int compression_level,	/* 0 to 9 */
	int interlaced,		/* 0 or 1 */
	int format,		/* 0 = B&W
				 * 1 = Greyscale
				 * 2 = Greyscale Alpha
				 * 3 = RGB
				 * 4 = RGBA */
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	)
);
#endif
/* Save Image With the TGA library */
extern int ImgWriteTGAFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t *rgba,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	int x, int y, int base_width, int base_height,
	const char *comments,
	int format,		/* 0 = Greyscale
				 * 1 = RGB
				 * 2 = RGBA */
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	)
);
#ifdef HAVE_LIBXPM
/* Save Image With libXpm */
extern int ImgXPMWriteFileRGBA(
	const char *filename,
	int width, int height,
	int bpl, int bpp,	/* bpp must be 4 */
	u_int8_t *rgba,
	const u_int8_t *bg_color,	/* 4 bytes in RGBA format */
	int x, int y, int base_width, int base_height,
	const char *c_id, const char *comments,
	int format,		/* 0 = Black & White
				 * 1 = Greyscale    
				 * 2 = Color */ 
	int max_colors,		/* -1 for no color limit */
	u_int8_t threshold,
	void *client_data,
	int (*progress_cb)( 
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */                  
	)
);
#endif




/* Private */

#ifdef HAVE_LIBGIF
/* Open Image With libgif */
extern int ImgGIFReadRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t ***rgba_rtn, unsigned long **delay_list_rtn,
	int *nframes_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	int *x_rtn, int *y_rtn,
	int *base_width_rtn, int *base_height_rtn,
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#endif

#ifdef HAVE_LIBJPEG
/* Open Image With libjpeg */
extern int ImgJPEGReadRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t **rgba_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#endif

#ifdef HAVE_LIBPNG
/* Open Image With libpng */
extern int ImgPNGReadRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t **rgba_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	int *x_rtn, int *y_rtn,
	int *base_width_rtn, int *base_height_rtn,
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#endif
/* Open Image With The TGA Library */
extern int ImgTGAReadRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t **rgba_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	int *x_rtn, int *y_rtn,
	int *base_width_rtn, int *base_height_rtn,
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#ifdef HAVE_LIBXPM
/* Open Image With The XPM Library */
extern int ImgXPMReadRGBA(
	const char *filename,
	int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
	u_int8_t **rgba_rtn,
	u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
	int *x_rtn, int *y_rtn,
	int *base_width_rtn, int *base_height_rtn,
	char **creator_rtn, char **title_rtn,
	char **author_rtn, char **comments_rtn,
	u_int8_t def_alpha_value,
	void *client_data,
	int (*progress_cb)(
		void *,		/* Data */
		int, int,	/* Progress current & end values */
		int, int,	/* Width & height */
		int, int,	/* Bytes per line & bytes per pixel */
		u_int8_t *	/* RGBA data */
	),
	int *user_aborted
);
#endif

#endif	/* IMGIO_H */
