#if !defined(WIN32)
#include <glib.h>
#include "print_values.h"
#include "config.h"

print_values_struct *PrintValuesNew(void);
void PrintValuesReset(print_values_struct *pv);
void PrintValuesDelete(print_values_struct *pv);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates new print values.
 */
print_values_struct *PrintValuesNew(void)
{
	return(PRINT_VALUES(g_malloc0(
	    sizeof(print_values_struct)
	)));
}

/*
 *	Resets the print values to the default values.
 */
void PrintValuesReset(print_values_struct *pv)
{
#if !defined(HAVE_XPRINT)
	const gchar *s;
#endif

	if(pv == NULL)
	    return;

#if defined(HAVE_XPRINT)
	pv->flags = (PRINT_VALUE_XPRINT_SERVER_ADDRESS |
	    PRINT_VALUE_PRINTER |
	    PRINT_VALUE_INPUT_TRAY |
	    PRINT_VALUE_MEDIUM |
	    PRINT_VALUE_ORIENTATION |
	    PRINT_VALUE_RESOLUTION |
	    PRINT_VALUE_BRIGHTNESS |
	    PRINT_VALUE_CONTRAST |
	    PRINT_VALUE_VISUAL |
	    PRINT_VALUE_FRAME |
	    PRINT_VALUE_OUTPUT_X |
	    PRINT_VALUE_OUTPUT_Y |
	    PRINT_VALUE_OUTPUT_WIDTH |
	    PRINT_VALUE_OUTPUT_HEIGHT |
	    PRINT_VALUE_OUTPUT_MAINTAIN_ASPECT |
	    PRINT_VALUE_OUTPUT_NCOPPIES
	);
	g_free(pv->xprint_server_address);
	pv->xprint_server_address = STRDUP(g_getenv(
	    "XPSERVERLIST"
	));
	pv->printer = NULL;
	pv->input_tray = NULL;
	pv->medium = NULL;
	pv->orientation = NULL;
	pv->resolution = 0;
	pv->brightness = 0.0f;
	pv->contrast = 0.0f;
	pv->visual = PRINT_VISUAL_RGB;
	pv->frame = 0;                
	pv->output_x = 0;  
	pv->output_y = 0;
	pv->output_width = 320;
	pv->output_height = 240;
	pv->output_maintain_aspect = TRUE;
	pv->output_ncoppies = 1; 
#else
	pv->flags = (PRINT_VALUE_OUTPUT_TYPE | PRINT_VALUE_PRINT_COMMAND |
	    PRINT_VALUE_FILE_NAME | PRINT_VALUE_BRIGHTNESS |
	    PRINT_VALUE_CONTRAST |
	    PRINT_VALUE_VISUAL | PRINT_VALUE_ORIENTATION |
	    PRINT_VALUE_DPI_X | PRINT_VALUE_DPI_Y |
	    PRINT_VALUE_PAPER_WIDTH | PRINT_VALUE_PAPER_HEIGHT |
	    PRINT_VALUE_FRAME |                               
	    PRINT_VALUE_OUTPUT_X | PRINT_VALUE_OUTPUT_Y |     
	    PRINT_VALUE_OUTPUT_WIDTH | PRINT_VALUE_OUTPUT_HEIGHT |
	    PRINT_VALUE_OUTPUT_MAINTAIN_ASPECT |
	    PRINT_VALUE_OUTPUT_NCOPPIES
	);
	pv->output = PRINT_OUTPUT_TO_PRINTER;

	s = g_getenv(ENV_VAR_NAME_PRINTCMD);
	if(s == NULL) 
	    s = g_getenv(ENV_VAR_NAME_PRINT);
	if(s == NULL)  
	    s = PRINT_DEF_COMMAND;
	g_free(pv->print_command);
	pv->print_command = STRDUP(s);

	s = g_getenv(ENV_VAR_NAME_HOME);
	if(s == NULL)
	    s = "";
	g_free(pv->file_name);
	pv->file_name = g_strconcat(
	    s,
	    G_DIR_SEPARATOR_S,
	    PRINT_DEF_FILE,
	    NULL
	);

	pv->brightness = 0.0f;
	pv->contrast = 0.0f;
	pv->visual = PRINT_VISUAL_RGB;
	pv->orientation = PRINT_ORIENTATION_PORTRAIT;                
	pv->dpi_x = 72;
	pv->dpi_y = 72;
	pv->paper_width = 850;		/* Letter sized paper */
	pv->paper_height = 1100;
	pv->frame = 0;
	pv->output_x = 0;
	pv->output_y = 0;
	pv->output_width = 320;
	pv->output_height = 240;
	pv->output_maintain_aspect = TRUE;
	pv->output_ncoppies = 1;
#endif
}

/*
 *	Deletes the print values.
 */
void PrintValuesDelete(print_values_struct *pv)
{
	if(pv == NULL)
	    return;

#if defined(HAVE_XPRINT)
	if(pv->flags & PRINT_VALUE_XPRINT_SERVER_ADDRESS)
	    g_free(pv->xprint_server_address);
	if(pv->flags & PRINT_VALUE_PRINTER)
	    g_free(pv->printer);
	if(pv->flags & PRINT_VALUE_INPUT_TRAY)
	    g_free(pv->input_tray);
	if(pv->flags & PRINT_VALUE_MEDIUM)
	    g_free(pv->medium);
	if(pv->flags & PRINT_VALUE_ORIENTATION)
	    g_free(pv->orientation);
#else
	if(pv->flags & PRINT_VALUE_PRINT_COMMAND)
	    g_free(pv->print_command);
	if(pv->flags & PRINT_VALUE_FILE_NAME)
	    g_free(pv->file_name);
#endif

	g_free(pv);
}

#endif	/* !WIN32 */
