/*
			      Print Values

	If HAVE_XPRINT is defined then the print_values_struct members
	will be declared to accomidate the X Print values needed,
	otherwise the default acoomidation for the lpr spooler will
	be declared instead.
 */

#ifndef PRINT_VALUES_H
#define PRINT_VALUES_H

#if !defined(WIN32)

#include <glib.h>


typedef struct _print_values_struct	print_values_struct;
#define PRINT_VALUES(p)			((print_values_struct *)(p))


#if defined(HAVE_XPRINT)
/*
 *	Print Value Flags:
 */
typedef enum {
	PRINT_VALUE_XPRINT_SERVER_ADDRESS = (1 << 0),	/* X Print server address */
	PRINT_VALUE_PRINTER		= (1 << 1),	/* Printer name */
	PRINT_VALUE_INPUT_TRAY		= (1 << 2),	/* Input tray name */
	PRINT_VALUE_MEDIUM		= (1 << 3),	/* Paper type name */
	PRINT_VALUE_ORIENTATION		= (1 << 4),	/* Orientation name */
	PRINT_VALUE_RESOLUTION		= (1 << 5),	/* DPI */
	PRINT_VALUE_BRIGHTNESS		= (1 << 5),
	PRINT_VALUE_CONTRAST		= (1 << 6),
	PRINT_VALUE_VISUAL		= (1 << 7),
	PRINT_VALUE_FRAME		= (1 << 8),
	PRINT_VALUE_OUTPUT_X		= (1 << 9),
	PRINT_VALUE_OUTPUT_Y		= (1 << 10),
	PRINT_VALUE_OUTPUT_WIDTH	= (1 << 11),
	PRINT_VALUE_OUTPUT_HEIGHT	= (1 << 12),
	PRINT_VALUE_OUTPUT_MAINTAIN_ASPECT	= (1 << 13),
	PRINT_VALUE_OUTPUT_NCOPPIES	= (1 << 14)
} print_value_flags;
#else
typedef enum {
	PRINT_VALUE_OUTPUT_TYPE		= (1 << 0),
	PRINT_VALUE_PRINT_COMMAND	= (1 << 1),
	PRINT_VALUE_FILE_NAME		= (1 << 2),
	PRINT_VALUE_BRIGHTNESS		= (1 << 3),
	PRINT_VALUE_CONTRAST		= (1 << 4),
	PRINT_VALUE_VISUAL		= (1 << 5),
	PRINT_VALUE_ORIENTATION		= (1 << 6),
	PRINT_VALUE_DPI_X		= (1 << 7),
	PRINT_VALUE_DPI_Y		= (1 << 8),
	PRINT_VALUE_PAPER_WIDTH		= (1 << 9),
	PRINT_VALUE_PAPER_HEIGHT	= (1 << 10),
	PRINT_VALUE_FRAME		= (1 << 11),
	PRINT_VALUE_OUTPUT_X		= (1 << 12),
	PRINT_VALUE_OUTPUT_Y		= (1 << 13),
	PRINT_VALUE_OUTPUT_WIDTH	= (1 << 14),
	PRINT_VALUE_OUTPUT_HEIGHT	= (1 << 15),
	PRINT_VALUE_OUTPUT_MAINTAIN_ASPECT	= (1 << 16),
	PRINT_VALUE_OUTPUT_NCOPPIES	= (1 << 17)
} print_value_flags;
#endif


#if !defined(HAVE_XPRINT)
/*
 *	Output:
 */
typedef enum {
	PRINT_OUTPUT_TO_PRINTER,
	PRINT_OUTPUT_TO_FILE
} print_output;
#endif


/*
 *	Visual:
 */
typedef enum {
	PRINT_VISUAL_BW,		/* Black & White */
	PRINT_VISUAL_GREYSCALE,		/* Greyscale */
	PRINT_VISUAL_RGB		/* Color */
} print_visual;


#if !defined(HAVE_XPRINT)
/*
 *	Orientation:
 */
typedef enum {
	PRINT_ORIENTATION_PORTRAIT,
	PRINT_ORIENTATION_LANDSCAPE
} print_orientation;
#endif


#if !defined(HAVE_XPRINT)
/*
 *	Paper Sizes List:
 *
 *	Each entry contains four values:
 *
 *	char *name, char *dimensions, int width, int height, int units
 *
 *	Where width and height are in pixels at 100 dpi.
 */
#define PAPER_SIZE_LIST		{ \
{	"Letter",	"8.5 x 11 in",		850,	1100	}, \
{	"Legal",	"8.5 x 14 in",		850,	1400	}, \
{	"Tabloid",	"11 x 17 in",		1100,	1700	}, \
{	"Ledger",	"17 x 11 in",		1700,	1100	}, \
{	"Executive",	"7.5 x 10 in",		750,	1000	}, \
{	"A3",		"11.69 x 16.53 in",	1169,	1653	}, \
{	"A4",		"8.26 x 11.69 in",	826,	1169	}, \
{	"A5",		"5.83 x 8.26 in", 	583,	826	}, \
{	"B4",		"9.83 x 13.93 in",	983,	1393	}, \
{	"B5",		"7.17 x 10.12 in",	717,	1012	}, \
{	NULL,		NULL,			0,	0	} \
}
#endif


/*
 *	Print Values:
 */
struct _print_values_struct {

	/* Flags that indicate which members are defined */
	print_value_flags	flags;

#if defined(HAVE_XPRINT)
	gchar		*xprint_server_address, /* X Print Server Address */
			*printer,	/* Printer name */
			*input_tray,	/* Input tray name */
			*medium,	/* Medium name */
			*orientation;	/* Orientation name */
	gint		resolution;	/* In DPI */
	gfloat		brightness;	/* -1.0 to 1.0 */
	gfloat		contrast;	/* -1.0 to 1.0 */
	print_visual	visual;
#else
	print_output	output;
	gchar		*print_command;
	gchar		*file_name;
	gfloat		brightness;	/* -1.0 to 1.0 */
	gfloat		contrast;	/* -1.0 to 1.0 */
	print_visual	visual;
	print_orientation orientation;
	gint		dpi_x,
			dpi_y;
	gint		paper_width,	/* In pixels without dpi applied */
			paper_height;
#endif

	gint		frame;		/* Frame index */

	/* Output geometry
	 *
	 * Matches upper-left portrait orientation, size will already
	 * be modified for correct orientation
	 */
	gint		output_x,	/* In pixels from upper-left corner */
			output_y;
	gint		output_width,	/* In pixels */
			output_height;
	gboolean	output_maintain_aspect;
	gint		output_ncoppies;
};


extern print_values_struct *PrintValuesNew(void);
extern void PrintValuesReset(print_values_struct *pv);
extern void PrintValuesDelete(print_values_struct *pv);


#endif  /* !WIN32 */

#endif	/* PRINT_VALUES_H */

