/*
* This file is part of Sir, an open-source cross-platform Image tool
* 2007  Rafael Sachetto
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Rafael Sachetto <rsachetto@gmail.com>
* Program URL   : http://rsachetto.googlepages.com
*
* File contributed by: Víctor Fernández <deejayworld@gmail.com>
*/

#include <QThread>
#include <QImage>
#include <QQueue>
#include <QDir>
#include <QMutex>
#include <QWaitCondition>
#include <QStringList>

#ifndef CONVERTTHREAD_H
#define CONVERTTHREAD_H

class ConvertThread : public QThread {

    Q_OBJECT

    public:
        ConvertThread(QObject *parent = 0);
        void setDesiredSize(int width, int height, bool hasWidth = true, bool hasHeight = false, bool maintainAspect = false);
        void setDesiredFormat(const QString& format);
        void setDesiredRotation(bool rotate, double angle = 0.0);
        void setQuality(int quality);
        void setDestPrefix(const QString& destPrefix);
        void setDestFolder(const QDir& destFolder);
        void setOverwriteAll(bool overwriteAll = false);
        void enqueueImage(const QString& name, const QString& extension, const QString& path);
        void confirmOverwrite(int result);

signals:
        void imageStatus(QStringList imageData, QString status, int statusNum);
        void overwriteQuestion(const QString& targetFile);

    private:
        void run();

        QMutex m_mutex;
        QQueue<QStringList> m_imageQueue;
        int m_width;
        int m_height;
        bool m_hasWidth;
        bool m_hasHeight;
        bool m_maintainAspect;
        QString m_format;
        bool m_rotate;
        double m_angle;
        int m_quality;	
        QString m_destPrefix;
        QDir m_destFolder;
        bool m_overwriteAll;

        QMutex m_overwriteMutex;
        QWaitCondition m_overwriteCondition;
        int m_overwriteResult;
};

#endif
