#include "languageutils.h"
#include <QStringList>
#include <QDebug>
#include <QFile>

LanguageUtils::LanguageUtils() {

    this->readLanguages();

}

LanguageUtils::~LanguageUtils() {

    delete languageInfoMap;

}

void LanguageUtils::readLanguages() {

    /*
        Here we read and create a map to hold the informations about
        Language names
    */

    languageInfoMap = new QMap<QString, LanguageInfo>;

    QFile translationsFile(":translations/translation_info.txt");

    if (!translationsFile.open(QIODevice::ReadOnly | QIODevice::Text))
        return;

    QTextStream in(&translationsFile);

    //We have to initialize en language by hand

    LanguageInfo info;
    info.niceName = "English";
    info.flagFile = "english.png";

    languageInfoMap->insert("sir_en_US.qm", info);

    while (!in.atEnd()) {
        QString line = in.readLine();
        QStringList languageData = line.split(",");

        LanguageInfo info;
        info.niceName = languageData[1];
        info.flagFile = languageData[2];

        languageInfoMap->insert(languageData[0], info);

    }

}

const LanguageInfo LanguageUtils::getLanguageInfo(const QString & language) const {
    return languageInfoMap->value(language);
}
