/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *   Copyright (C) 2005 Boaz Anin <boazanin@gmail.com>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "phish_util_ll.h"


phish_util_ListElem *phish_util_newListElem()
{
  phish_util_ListElem *result = malloc(sizeof(phish_util_ListElem));
  
  if (result == NULL)
    return NULL;

  phish_util_setListData(result, NULL);
  phish_util_setListNext(result, NULL);

  return result;
}

void *phish_util_listData(phish_util_ListElem *l)
{
  if (l == NULL)
    return NULL;
  else
    return l->data;
}

void phish_util_setListData(phish_util_ListElem *l, void *d)
{
  if (l == NULL)
    return;
  else
    l->data = d;
}

phish_util_ListElem *phish_util_listNext(phish_util_ListElem *l)
{
  if (l == NULL)
    return NULL;
  else
    return l->next;
}

void phish_util_setListNext(phish_util_ListElem *l, phish_util_ListElem *n)
{
  if (l == NULL)
    return;
  else
    l->next = n;
}

phish_util_LinkedList *phish_util_newList()
{
  phish_util_LinkedList *newl;

  newl = malloc(sizeof(phish_util_LinkedList));

  if (newl == NULL)
    return NULL;

  newl->head = NULL;
  newl->tail = NULL;
  newl->length = 0;

  return newl;
}

void phish_util_addToList(phish_util_LinkedList *list, void *newdata)
{
  phish_util_ListElem *elem = phish_util_newListElem();

  if (list == NULL || elem == NULL)
    return;

  phish_util_setListData(elem, newdata);

  if (list->head == NULL)              /* if the list is empty */
  {
    list->head = elem;              /* add it to the beginning of the list */
    list->tail = elem;
  }
  else
  {
    phish_util_setListNext(list->tail, elem);/* add it at the end of the list */
    list->tail = elem;
  }

  list->length++;
}


/* A recursive function used only by deleteList, which deallocates all the
 * list elements.
 */
static void recursiveDeleteElements(phish_util_ListElem *elem)
{
  if (elem == NULL)
    return;
  else
    recursiveDeleteElements(phish_util_listNext(elem));

  free(elem);
}

void phish_util_deleteList(phish_util_LinkedList *list)
{
  if (list->head != NULL)
    recursiveDeleteElements(list->head);

  free(list);
}

phish_util_ListElem *phish_util_listHead(phish_util_LinkedList *list)
{
  if (list == NULL)
    return NULL;
  else
    return list->head;
}

void phish_util_deepDeleteList(phish_util_LinkedList *list)
{
  phish_util_ListElem *l;
  void *vp;

  for (l = phish_util_listHead(list) ; l != NULL ; l = phish_util_listNext(l))
  {
    vp = phish_util_listData(l); /* deallocate objects pointed to by      */
    free(vp);                    /* the data of each of the list elements */
  }

  phish_util_deleteList(list);   /* then, delete the list itself */
}

unsigned int phish_util_listLength(const phish_util_LinkedList *list)
{
  if (list == NULL)
    return 0;
  else
    return list->length;
}

