#include <stdio.h>
#include <stdlib.h>
#include "../phish.h"
#include "../phish_local_xml.h"

int main(int argc, char *argv[])
{
  phish_result_t r;
  phish_url_data_t *results;

  if (argc < 2)
  {
    fprintf(stderr, "\nUsage: %s [well-formed url] [ip]\n", argv[0]);
    return 1;
  }

  results = (phish_url_data_t*)malloc(sizeof(phish_url_data_t));

  /* Initialize the url data structure */
  results->comments = NULL;
  results->comments_length = 0;
  results->country[0] = '-';
  results->country[1] = '-';
  results->ip = 0;
  results->path = 0;
  results->risk_level = 0;
  results->server = 0;

  if ((r = phish_localxml_checkURL(argv[1], argv[2], results)) != PHISH_SUCCESS)
  {
    printf("Error checking URL. Result = %d\n", r); /* we can of course check which error caused the problem... */
    return 0;
  }

  /* testing */
  printf("Testing %s:\nServer found:%d\nPath found:%d\n"
         "IP found:%d\n%s\n", argv[1],
          results->server, results->path, results->ip, results->comments);

  
  free(results);
  return 0;
}
