/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <stdlib.h>
#include <stdio.h>

#include "../phish.h"
#include "../phish_opdb_server.h"

#define USER_AGENT "FakeUA/1.0"
#define CLIENT_VER "FakeUA Anti-Phishing Toolbar 0.1.0"

int main(int argc, char *argv[])
{
  phish_url_data_t reply;
  phish_result_t r;
  
  if (argc != 3)
  {
    printf("Usage: %s url ip\n", argv[0]);
    exit(1);
  }
  
  phish_init(USER_AGENT, CLIENT_VER);
  
  r = phish_opdbserver_checkURL(argv[1], argv[2], &reply);
  if (r != PHISH_SUCCESS)
  {
    fprintf(stderr, "Error querying server\n");
    exit(1);
  }
  
  printf("Server's reply:\n"
         "Server: %d\n"
         "IP: %d\n"
         "Path: %d\n"
         "Country: %s\n\n", reply.server, reply.ip, reply.path, reply.country);
  
  if (reply.comments_length == 0)
    printf("No comments\n");
  else
  {
    printf("Comments:\n"
           "%s\n", reply.comments);
    free(reply.comments);
  }
  
  r = phish_opdbserver_downloadDBAsXML();
  if (r == PHISH_XML_NOT_MODIFIED)
    printf("XML file on server not modified.\n");
  else if (r != PHISH_SUCCESS)
    fprintf(stderr, "Error downloading XML file on server: %d\n", r);
  else
    printf("XML file on server downloaded.\n");
  
  phish_shutdown();
  
  return 0;
}

