/* camstream main module.
   (C) 1999,2000 Nemosoft Unv.

   This program is covered by the GPL, version 2 or later.
 */

/**
  \mainpage CamStream API documentation

  \section intro Introduction

  These pages contain documentation about the classes that are used in/built
  for the CamStream application.

  There's more to come. In the mean time, just browse the class hierarchy.

  \b Note: the GUI classes (made with Qt Designer) are not documented.

 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include <qglobal.h>
#include <qmotifstyle.h>
#include <qnetwork.h>

#include "tracer.h"

#include "CamStreamMainWindow.h"
#include "CamStreamApp.h"

int main(int argc, char *argv[])
{
   int ret;

   qInitNetworkProtocols();
   {
     CCamStreamApp CamApp(argc, argv);
     CCamStreamMainWindow *pMainWindow;

//   QApplication::setStyle(new QMotifStyle);

     pMainWindow = new CCamStreamMainWindow();
     CamApp.setMainWidget(pMainWindow);
     pMainWindow->setCaption("CamStream");
     pMainWindow->show();
     CamApp.connect(&CamApp, SIGNAL(lastWindowClosed()), &CamApp, SLOT(quit()));
     ret = CamApp.exec();
     delete pMainWindow;
     /* CamApp must go out out scope properly */
   }
   return ret;
}
