#ifndef TRACER_H
#define TRACER_H

#if defined(NDEBUG)
/* Release version: do nothing */

#define TR_MODULE(name)
#define TR_SET_CONFIG(xml_node)
#define TR_GET_CONFIG(xml_node)
#define TR_SHOW()
#define TR_HIDE()
#define TR_ENTER()
#define TR_LEAVE()
#define TR_RET(value) return value
#define TR_RETURN() return
#define TR

#else

#include "TraceManager.h"

extern CTraceManager TraceManager;

#if defined(__GNUC__)
#define FUNCNAME __PRETTY_FUNCTION__
#elif defined(_MSC_VER)
#define FUNCNAME __FILE__,__LINE__
#else
#error Compiler not supported (neither GNU C or Microsoft Visual Studio)
#endif

/* Debug version */
#define TR_MODULE(name) static CTraceModule *s_trace_module = CTraceManager::Instance()->RegisterModule(name)

#define TR_SET_CONFIG(xml_node) CTraceManager::Instance()->SetConfiguration(xml_node)
#define TR_GET_CONFIG(xml_node) CTraceManager::Instance()->GetConfiguration(xml_node)

#define TR_SHOW()     CTraceManager::Instance()->Show()
#define TR_HIDE()     CTraceManager::Instance()->Hide()

#define TR_ENTER() s_trace_module->Enter(FUNCNAME)
#define TR_LEAVE() s_trace_module->Leave(FUNCNAME)
#define TR_RET(value)\
	{\
	s_trace_module->Leave(FUNCNAME);\
	return value;\
	}
#define TR_RETURN()\
	{\
	s_trace_module->Leave(FUNCNAME);\
	return;\
	}
#define TR s_trace_module->Log
#endif

#endif
